/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.holder;

import java.lang.reflect.InvocationTargetException;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.holder.Holder;
import org.openscdp.pkidm.holder.HolderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HolderFactoryBase
implements HolderFactory {
    final Logger logger = LoggerFactory.getLogger(HolderFactoryBase.class);
    private Class<? extends Holder> clazz;
    private String type;

    public HolderFactoryBase(Class<? extends Holder> clazz) {
        this.clazz = clazz;
        try {
            this.type = clazz.getField("TYPE").get(clazz).toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Can not locate TYPE field in class", e);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Holder getByDTO(HolderDTO dto) {
        Holder holder;
        try {
            holder = this.clazz.getDeclaredConstructor(HolderDTO.class).newInstance(dto);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error("Failed to construct holder object", (Throwable)e);
            throw new RuntimeException("Failed to construct holder object", e);
        }
        return holder;
    }
}

