/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.holder;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.holder.CertificateHolder;

public class CVCertificateHolder
extends CertificateHolder {
    public CVCertificateHolder(HolderDTO dto) {
        super(dto);
    }

    public CVCertificateHolder getParent() {
        return super.getParent(CVCertificateHolder.class);
    }

    public CardVerifiableCertificate getCurrentCertificate() {
        CertificateDTO certDTO = this.getCurrentCertificateDTO();
        if (certDTO == null) {
            return null;
        }
        try {
            return new CardVerifiableCertificate(certDTO.getBytes());
        }
        catch (CertificateException e) {
            throw new RuntimeException("Invalid certificate in database", e);
        }
    }

    private static CertificateDTO toCertificateDTO(CardVerifiableCertificate cvc) {
        Date d;
        CertificateDTO certDTO = new CertificateDTO();
        try {
            certDTO.setBytes(cvc.getEncoded());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            // empty catch block
        }
        String chr = cvc.getCertificateHolderReference().toString();
        certDTO.setKeyId(chr.getBytes());
        CertificateExpirationDate cxd = cvc.getCVCertificate().getCertificateBody().getCertificateExpirationDate();
        byte[] v = cxd.getValue();
        String cxdStr = "" + v[0];
        cxdStr = cxdStr + v[1];
        cxdStr = cxdStr + "-" + v[2];
        cxdStr = cxdStr + v[3];
        cxdStr = cxdStr + "-" + v[4];
        cxdStr = cxdStr + v[5];
        SimpleDateFormat formatter = new SimpleDateFormat("yy-MM-dd");
        try {
            d = formatter.parse(cxdStr);
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date encoding in CV certificate", e);
        }
        certDTO.setExpiry(Long.valueOf(d.getTime()));
        if (cvc.getCertificationAuthorityReference().toString().equals(cvc.getCertificateHolderReference().toString())) {
            certDTO.setLinkDir(1);
        } else {
            certDTO.setLinkDir(0);
        }
        certDTO.setSerial(chr);
        return certDTO;
    }

    public void storeCertificate(CardVerifiableCertificate cvc, boolean makeCurrent, Long srId) {
        CertificateDTO certDTO = CVCertificateHolder.toCertificateDTO(cvc);
        certDTO.setHolderId(this.getId());
        certDTO.setServiceRequestId(srId);
        try (Handle handle = PKIDMContext.getJDBI().open();){
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            certDAO.create(certDTO);
            if (makeCurrent) {
                HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
                holderDAO.updateCurrentCertificate(certDTO.getId(), this.getId());
            }
        }
    }
}

