/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.form;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedList;
import java.util.List;
import org.openscdp.pkidm.form.Field;
import org.openscdp.pkidm.form.Section;
import org.openscdp.pkidm.form.SelectField;
import org.openscdp.pkidm.form.StringInputField;
import org.openscdp.pkidm.form.StringSelectField;
import org.openscdp.pkidm.form.ValueField;

public class Form {
    public String id;
    public String legend;
    public List<Section> sections = new LinkedList<Section>();

    public List<Section> getSections() {
        return this.sections;
    }

    private boolean setField(ValueField field, JsonNode n) {
        StringSelectField f;
        if (field instanceof StringInputField) {
            StringInputField f2 = (StringInputField)field;
            String val = n.asText();
            if (!f2.isValid(val)) {
                return false;
            }
            f2.setValue(val);
        } else if (field instanceof SelectField) {
            SelectField f3 = (SelectField)field;
            Long val = n.asLong();
            if (!f3.isValid(val)) {
                return false;
            }
            f3.setValue(val);
        } else if (field instanceof StringSelectField && !(f = (StringSelectField)field).setValueFromId(n.asLong())) {
            return false;
        }
        return true;
    }

    public boolean setFields(JsonNode input) {
        boolean isValid = true;
        for (Section section : this.sections) {
            for (Field field : section.fields) {
                String id;
                JsonNode n;
                if (!(field instanceof ValueField)) continue;
                ValueField valueField = (ValueField)field;
                if (!valueField.editable || (n = input.get(id = field.id)) == null || this.setField(valueField, n)) continue;
                isValid = false;
            }
        }
        return isValid;
    }
}

