/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.persistence;

import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.persistence.Holders;

public class DBHolders
implements Holders {
    private HolderDAO holderDAO;

    public DBHolders(Handle handle) {
        this.holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
    }

    @Override
    public String getPath(Long holderId) throws Exception {
        HolderDTO dto;
        Object path = "";
        do {
            dto = this.holderDAO.getHolder(holderId);
            path = "/" + dto.getName() + (String)path;
        } while ((holderId = dto.getParentId()) != null);
        return path;
    }

    @Override
    public HolderDTO getCVCHolder(String path) throws Exception {
        return this.getHolder(path, 1);
    }

    @Override
    public HolderDTO getHolder(String path, int certificateType) throws Exception {
        Long holderId = this.holderDAO.determineId(path, certificateType);
        if (holderId == null) {
            return null;
        }
        return this.holderDAO.getHolder(holderId);
    }

    @Override
    public HolderDTO newHolder(String path, int certificateType) throws Exception {
        int idx = path.lastIndexOf("/");
        String parentPath = path.substring(0, idx);
        String holderName = path.substring(idx + 1);
        if (holderName.length() == 0) {
            throw new Exception("Invalid path " + path + ": missing required holder name");
        }
        Long parentId = null;
        if (parentPath.length() > 0 && (parentId = this.holderDAO.determineId(parentPath, certificateType)) == null) {
            throw new Exception("Invalid path " + path + ": parent holder " + parentPath + " does not exist");
        }
        return this.newHolderForParent(parentId, certificateType, holderName);
    }

    public HolderDTO newHolderForParent(Long parentId, int certificateType, String name) throws Exception {
        HolderDTO holder = new HolderDTO();
        holder.setParentId(parentId);
        holder.setCertificateType(certificateType);
        holder.setName(name);
        return this.holderDAO.create(holder);
    }

    @Override
    public HolderDTO newHolderForParent(HolderDTO parent, String name) throws Exception {
        if (parent.getId() == null && parent.getPath() == null || parent.getCertificateType() != 1 && parent.getCertificateType() != 2) {
            throw new Exception("Invalid parent " + parent);
        }
        Long parentId = parent.getId();
        if (parentId == null) {
            return this.newHolder(parent.getPath() + "/" + name, parent.getCertificateType());
        }
        return this.newHolderForParent(parentId, parent.getCertificateType(), name);
    }

    @Override
    public HolderDTO newCVCHolder(String path) throws Exception {
        return this.newHolder(path, 1);
    }

    @Override
    public void updateCurrentCertificate(HolderDTO holder, CertificateDTO certificate) {
        this.holderDAO.updateCurrentCertificate(certificate.getId(), holder.getId());
    }

    @Override
    public Long countSubHolder(HolderDTO holder) throws Exception {
        return this.holderDAO.countSubHolder(holder.getId());
    }
}

