/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.form;

import java.util.LinkedList;
import java.util.List;
import org.openscdp.pkidm.form.OptionGroupValue;
import org.openscdp.pkidm.form.SelectFieldValue;
import org.openscdp.pkidm.form.SelectValue;
import org.openscdp.pkidm.form.ValueField;

public class StringSelectField
extends ValueField<String> {
    public static String TYPE = "select";
    public List<SelectFieldValue> options = new LinkedList<SelectFieldValue>();
    public boolean multiSelect = false;
    public String onchange;

    public StringSelectField() {
        this(null, null, false, false);
    }

    public StringSelectField(String id, String label, boolean editable, boolean required) {
        this(id, label, editable, null, false);
    }

    public StringSelectField(String id, String label, boolean editable, String value, boolean required) {
        super(id, label, TYPE, editable, value, false);
    }

    public void add(SelectValue sv) {
        if (this.value == null) {
            if (sv.selected) {
                this.value = sv.value;
            }
        } else {
            if (sv.selected && sv.value.equals(this.value)) {
                throw new RuntimeException("Double selected option in single select field");
            }
            sv.selected = sv.value.equals(this.value);
        }
        this.options.add(sv);
    }

    public void setValueFromId(Long value) {
        for (SelectFieldValue option : this.options) {
            if (option instanceof SelectValue) {
                SelectValue sv = (SelectValue)option;
                boolean bl = sv.selected = sv.id == value;
                if (!sv.selected) continue;
                this.value = sv.value;
                continue;
            }
            OptionGroupValue og = (OptionGroupValue)option;
            for (SelectValue sv : og.value) {
                boolean bl = sv.selected = sv.id == value;
                if (!sv.selected) continue;
                this.value = sv.value;
            }
        }
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            return;
        }
        for (SelectFieldValue option : this.options) {
            if (option instanceof SelectValue) {
                SelectValue sv = (SelectValue)option;
                sv.selected = sv.value.equals(value);
                if (!sv.selected) continue;
                this.value = value;
                continue;
            }
            OptionGroupValue og = (OptionGroupValue)option;
            for (SelectValue sv : og.value) {
                sv.selected = sv.value.equals(value);
                if (!sv.selected) continue;
                this.value = value;
            }
        }
    }
}

