/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.form;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedList;
import java.util.List;
import org.openscdp.pkidm.form.Field;
import org.openscdp.pkidm.form.Section;
import org.openscdp.pkidm.form.SelectField;
import org.openscdp.pkidm.form.StringInputField;
import org.openscdp.pkidm.form.StringSelectField;
import org.openscdp.pkidm.form.ValueField;

public class Form {
    public String id;
    public String legend;
    public List<Section> sections = new LinkedList<Section>();

    public List<Section> getSections() {
        return this.sections;
    }

    private boolean setField(ValueField field, JsonNode n) {
        if (field instanceof StringInputField) {
            StringInputField f = (StringInputField)field;
            f.setValue(n.asText());
        } else if (field instanceof SelectField) {
            SelectField f = (SelectField)field;
            f.setValue(n.asLong());
        } else if (field instanceof StringSelectField) {
            StringSelectField f = (StringSelectField)field;
            f.setValueFromId(n.asLong());
        }
        return true;
    }

    public boolean setFields(JsonNode input) {
        boolean isValid = true;
        for (Section section : this.sections) {
            for (Field field : section.fields) {
                String id;
                JsonNode n;
                if (!(field instanceof ValueField)) continue;
                ValueField valueField = (ValueField)field;
                if (!valueField.editable || (n = input.get(id = field.id)) == null || this.setField(valueField, n)) continue;
                isValid = false;
            }
        }
        return isValid;
    }
}

