/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CVCertificateRequestGenerator;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.RequestDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.persistence.Certificates;
import org.openscdp.pkidm.persistence.DAOFactory;
import org.openscdp.pkidm.persistence.Holders;
import org.openscdp.pkidm.persistence.Requests;
import org.openscdp.pkidm.persistence.Signers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVCertificateStore {
    private final Logger logger = LoggerFactory.getLogger(CVCertificateStore.class);
    private DAOFactory daof;

    public CVCertificateStore(DAOFactory daof) {
        this.daof = daof;
    }

    public String getPathForHolderId(Long holderId) throws Exception {
        try (DAOFactory df = this.daof.open();){
            String path;
            String string = path = this.daof.getHolders().getPath(holderId);
            return string;
        }
    }

    public CertificateDTO toCertificateDTO(CardVerifiableCertificate cvc, HolderDTO holder, Long srId) throws ParseException, CertificateEncodingException {
        CertificateDTO certDTO = new CertificateDTO();
        certDTO.setBytes(cvc.getEncoded());
        String chr = cvc.getCertificateHolderReference().toString();
        certDTO.setKeyId(chr.getBytes());
        CertificateExpirationDate cxd = cvc.getCVCertificate().getCertificateBody().getCertificateExpirationDate();
        byte[] v = cxd.getValue();
        String cxdStr = "" + v[0];
        cxdStr = cxdStr + v[1];
        cxdStr = cxdStr + "-" + v[2];
        cxdStr = cxdStr + v[3];
        cxdStr = cxdStr + "-" + v[4];
        cxdStr = cxdStr + v[5];
        SimpleDateFormat formatter = new SimpleDateFormat("yy-MM-dd");
        Date d = formatter.parse(cxdStr);
        certDTO.setExpiry(Long.valueOf(d.getTime()));
        if (cvc.getCertificationAuthorityReference().toString().equals(cvc.getCertificateHolderReference().toString())) {
            certDTO.setLinkDir(1);
        } else {
            certDTO.setLinkDir(0);
        }
        certDTO.setSerial(chr);
        certDTO.setHolderId(holder.getId());
        certDTO.setServiceRequestId(srId);
        return certDTO;
    }

    public void storeCertificate(String path, CardVerifiableCertificate cvc, boolean makeCurrent, Long srId) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Holders holders = df.getHolders();
            HolderDTO holder = this.getOrCreateHolder(path);
            CertificateDTO certDTO = this.toCertificateDTO(cvc, holder, srId);
            Certificates certs = df.getCertificates();
            certs.newCertificate(certDTO);
            if (makeCurrent) {
                holders.updateCurrentCertificate(holder, certDTO);
            }
        }
    }

    public CertificateDTO getCertificateDTO(String path, CertificateHolderReference chr, boolean selfsigned) throws Exception {
        try (DAOFactory df = this.daof.open();){
            HolderDTO holder = this.getHolder(path);
            Certificates certs = df.getCertificates();
            int linkDir = selfsigned ? 1 : 0;
            CertificateDTO certificateDTO = certs.getCertificate(holder, chr.toString(), linkDir);
            return certificateDTO;
        }
    }

    public CardVerifiableCertificate getCertificate(String path, CertificateHolderReference chr, boolean selfsigned) throws CertificateException, Exception {
        return new CardVerifiableCertificate(this.getCertificateDTO(path, chr, selfsigned).getBytes());
    }

    public HolderDTO getOrCreateHolder(String path) throws Exception {
        HolderDTO holder = this.getHolder(path);
        if (holder == null) {
            try (DAOFactory df = this.daof.open();){
                this.logger.debug("Create new holder for path " + path);
                Holders holders = df.getHolders();
                holder = holders.newCVCHolder(path);
            }
        }
        return holder;
    }

    public HolderDTO getHolder(String path) throws Exception {
        try (DAOFactory df = this.daof.open();){
            HolderDTO holder;
            Holders holders = df.getHolders();
            HolderDTO holderDTO = holder = holders.getCVCHolder(path);
            return holderDTO;
        }
    }

    public CertificateDTO getCurrentCertificate(String path) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Holders holders = df.getHolders();
            HolderDTO holder = holders.getCVCHolder(path);
            CertificateDTO certificateDTO = this.getCurrentCertificate(holder);
            return certificateDTO;
        }
    }

    public CertificateDTO getCurrentCertificate(HolderDTO holder) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Certificates certs = df.getCertificates();
            CertificateDTO certificateDTO = certs.getCurrentCertificate(holder);
            return certificateDTO;
        }
    }

    public CertificateHolderReference getNextCHR(HolderDTO parentHolder, long offset, String prefix) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Holders holders = df.getHolders();
            long count = holders.countSubHolder(parentHolder);
            CertificateHolderReference chr = this.getCHR(prefix, offset + count);
            holders.newHolderForParent(parentHolder, chr.getHolder());
            CertificateHolderReference certificateHolderReference = chr;
            return certificateHolderReference;
        }
    }

    public CertificateHolderReference getCHR(String prefix, long count) {
        String sequence = "" + count;
        String chrStr = prefix + "00000".substring(sequence.length()) + sequence + "00000";
        CertificateHolderReference chr = new CertificateHolderReference(chrStr);
        return chr;
    }

    private KeyPair generateKeyPair(Provider p, AlgorithmParameterSpec params) throws Exception {
        KeyPairGenerator keyGen = params instanceof ECGenParameterSpec ? KeyPairGenerator.getInstance("EC", p) : KeyPairGenerator.getInstance("RSA", p);
        keyGen.initialize(params);
        KeyPair kp = keyGen.generateKeyPair();
        return kp;
    }

    public CardVerifiableCertificate generateRequest(Provider p, AlgorithmParameterSpec params, String path, CertificationAuthorityReference car, CertificateHolderReference chr) throws Exception {
        KeyPair kp = this.generateKeyPair(p, params);
        CVCertificateRequestGenerator reqGen = new CVCertificateRequestGenerator();
        reqGen.setCertificateHolderReference(chr);
        reqGen.setCertificationAuthorityReference(car);
        reqGen.setPublicKey(kp.getPublic());
        CVCertificate asn1Req = reqGen.generate(kp.getPrivate());
        CardVerifiableCertificate req = new CardVerifiableCertificate(asn1Req.getBytes());
        try (DAOFactory df = this.daof.open();){
            HolderDTO holder = this.getOrCreateHolder(path);
            Signers signers = this.daof.getSigners();
            byte[] keyDomain = null;
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)kp.getPrivate().getEncoded());
            byte[] keyblob = privateKeyInfo.getEncoded();
            signers.newSigner(holder, path, chr.getBytes(), keyDomain, keyblob);
            this.storeRequest(holder, asn1Req.getBytes(), chr.getBytes());
        }
        return req;
    }

    public void storeSigner(String path, String name, byte[] keyId, byte[] keyDomain, byte[] keyblob) throws Exception {
        try (DAOFactory df = this.daof.open();){
            HolderDTO holder = this.getHolder(path);
            Signers signers = this.daof.getSigners();
            signers.newSigner(holder, name, keyId, keyDomain, keyblob);
        }
    }

    public SignerDTO getSigner(String path, CertificateHolderReference chr) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Signers signers = this.daof.getSigners();
            HolderDTO holder = this.getHolder(path);
            SignerDTO signerDTO = signers.getSignerByHolderAndKeyId(holder, chr.toString().getBytes());
            return signerDTO;
        }
    }

    public PrivateKey getPrivateKey(Provider p, String path, CertificateHolderReference chr) throws Exception {
        try (DAOFactory df = this.daof.open();){
            PrivateKey prk;
            Signers signers = this.daof.getSigners();
            SignerDTO signer = signers.getSignerByHolderAndKeyId(this.getHolder(path), chr.getBytes());
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(signer.getKeyblob());
            KeyFactory kf = KeyFactory.getInstance("EC", p);
            PrivateKey privateKey = prk = kf.generatePrivate(spec);
            return privateKey;
        }
    }

    private void storeRequest(HolderDTO holder, byte[] req, byte[] keyId) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Requests requests = this.daof.getRequests();
            requests.newRequest(holder, keyId, req);
        }
    }

    public void storeRequest(String path, byte[] req, byte[] keyId) throws Exception {
        HolderDTO holder = this.getHolder(path);
        this.storeRequest(holder, req, keyId);
    }

    public CardVerifiableCertificate getRequest(String path, CertificateHolderReference chr) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Requests requests = this.daof.getRequests();
            RequestDTO req = requests.getRequest(this.getHolder(path), chr.toString().getBytes());
            CardVerifiableCertificate cardVerifiableCertificate = new CardVerifiableCertificate(req.getBytes());
            return cardVerifiableCertificate;
        }
    }
}

