/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.servicerequest;

import java.util.HashMap;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRequestFactoryRegistry {
    final Logger logger = LoggerFactory.getLogger(ServiceRequestFactoryRegistry.class);
    private Jdbi jdbi;
    HashMap<String, ServiceRequestFactory> registry = new HashMap();

    public void setJDBI(Jdbi jdbi) {
        this.jdbi = jdbi;
    }

    public void addServiceRequestFactory(String process, ServiceRequestFactory factory) {
        if (this.registry.containsKey(process)) {
            this.logger.warn("Overwriting factory " + this.registry.get(process) + " for " + process + " with " + factory);
        }
        this.registry.put(process, factory);
    }

    public void addServiceRequestFactory(ServiceRequestFactory factory) {
        this.addServiceRequestFactory(factory.getProcess(), factory);
    }

    public ServiceRequestFactory getFactoryForProcess(String process) {
        if (!this.registry.containsKey(process)) {
            this.logger.warn("No factory found for process " + process);
        }
        ServiceRequestFactory factory = this.registry.get(process);
        return factory;
    }

    public boolean isSupported(ServiceRequestDTO dto) {
        String process = dto.getProcess();
        if (process == null) {
            return false;
        }
        ServiceRequestFactory factory = this.getFactoryForProcess(process);
        return factory != null;
    }

    public ServiceRequest getByDTO(ServiceRequestDTO dto) {
        String process = dto.getProcess();
        if (process == null) {
            throw new RuntimeException("process can not be null");
        }
        ServiceRequestFactory factory = this.getFactoryForProcess(process);
        if (factory == null) {
            throw new RuntimeException("No factory found for " + process);
        }
        ServiceRequest sr = factory.getByDTO(dto);
        return sr;
    }

    public <T extends ServiceRequest> T getById(Long id, Class<T> type) {
        ServiceRequestDTO dto;
        try (Handle handle = this.jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dto = dao.getServiceRequest(id);
        }
        if (dto == null) {
            throw new RuntimeException("ServiceRequest with id " + id + " not found");
        }
        ServiceRequest serviceRequest = this.getByDTO(dto);
        return (T)((ServiceRequest)type.cast(serviceRequest));
    }
}

