/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.persistence;

import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.RequestDAO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.RequestDTO;
import org.openscdp.pkidm.persistence.Requests;

public class DBRequests
implements Requests {
    private RequestDAO requestDAO;

    public DBRequests(Handle handle) {
        this.requestDAO = (RequestDAO)handle.attach(RequestDAO.class);
    }

    @Override
    public RequestDTO newRequest(HolderDTO holder, byte[] keyId, byte[] encodedRequest) {
        RequestDTO req = new RequestDTO();
        req.setHolderId(holder.getId());
        req.setKeyId(keyId);
        req.setBytes(encodedRequest);
        this.requestDAO.insert(req);
        return req;
    }

    @Override
    public RequestDTO getRequest(HolderDTO holder, byte[] keyId) {
        return this.requestDAO.getRequestByKeyId(holder.getId(), keyId);
    }
}

