/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.persistence.Certificates;
import org.openscdp.pkidm.persistence.DAOFactory;
import org.openscdp.pkidm.persistence.Holders;
import org.openscdp.pkidm.persistence.Signers;

public class CVCertificateStore {
    private DAOFactory daof;

    public CVCertificateStore(DAOFactory daof) {
        this.daof = daof;
    }

    public CertificateDTO toCertificateDTO(CardVerifiableCertificate cvc, HolderDTO holder, Long srId) throws ParseException, CertificateEncodingException {
        CertificateDTO certDTO = new CertificateDTO();
        certDTO.setBytes(cvc.getEncoded());
        String chr = cvc.getCertificateHolderReference().toString();
        certDTO.setKeyId(chr.getBytes());
        CertificateExpirationDate cxd = cvc.getCVCertificate().getCertificateBody().getCertificateExpirationDate();
        byte[] v = cxd.getValue();
        String cxdStr = "" + v[0];
        cxdStr = cxdStr + v[1];
        cxdStr = cxdStr + "-" + v[2];
        cxdStr = cxdStr + v[3];
        cxdStr = cxdStr + "-" + v[4];
        cxdStr = cxdStr + v[5];
        SimpleDateFormat formatter = new SimpleDateFormat("yy-MM-dd");
        Date d = formatter.parse(cxdStr);
        certDTO.setExpiry(Long.valueOf(d.getTime()));
        if (cvc.getCertificationAuthorityReference().toString().equals(cvc.getCertificateHolderReference().toString())) {
            certDTO.setLinkDir(1);
        } else {
            certDTO.setLinkDir(0);
        }
        certDTO.setSerial(chr);
        certDTO.setHolderId(holder.getId());
        certDTO.setServiceRequestId(srId);
        return certDTO;
    }

    public void storeCertificate(String path, CardVerifiableCertificate cvc, boolean makeCurrent, Long srId) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Holders holders = df.getHolders();
            HolderDTO holder = holders.getCVCHolder(path);
            if (holder == null) {
                holder = holders.newCVCHolder(path);
            }
            CertificateDTO certDTO = this.toCertificateDTO(cvc, holder, srId);
            Certificates certs = df.getCertificates();
            certs.newCertificate(certDTO);
            if (makeCurrent) {
                holders.updateCurrentCertificate(holder, certDTO);
            }
        }
    }

    public CertificateDTO getCertificateDTO(String path, CertificateHolderReference chr, boolean selfsigned) throws Exception {
        try (DAOFactory df = this.daof.open();){
            HolderDTO holder = this.getHolder(path);
            Certificates certs = df.getCertificates();
            int linkDir = selfsigned ? 1 : 0;
            CertificateDTO certificateDTO = certs.getCertificate(holder, chr.toString(), linkDir);
            return certificateDTO;
        }
    }

    public CardVerifiableCertificate getCertificate(String path, CertificateHolderReference chr, boolean selfsigned) throws CertificateException, Exception {
        return new CardVerifiableCertificate(this.getCertificateDTO(path, chr, selfsigned).getBytes());
    }

    public HolderDTO getHolder(String path) throws Exception {
        try (DAOFactory df = this.daof.open();){
            HolderDTO holder;
            Holders holders = df.getHolders();
            HolderDTO holderDTO = holder = holders.getCVCHolder(path);
            return holderDTO;
        }
    }

    public CertificateDTO getCurrentCertificate(String path) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Holders holders = df.getHolders();
            HolderDTO holder = holders.getCVCHolder(path);
            CertificateDTO certificateDTO = this.getCurrentCertificate(holder);
            return certificateDTO;
        }
    }

    public CertificateDTO getCurrentCertificate(HolderDTO holder) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Certificates certs = df.getCertificates();
            CertificateDTO certificateDTO = certs.getCurrentCertificate(holder);
            return certificateDTO;
        }
    }

    public SignerDTO getSigner(HolderDTO holder, CertificateHolderReference chr) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Signers signers = this.daof.getSigners();
            SignerDTO signerDTO = signers.getSignerByHolderAndKeyId(holder, chr.toString().getBytes());
            return signerDTO;
        }
    }

    public CertificateHolderReference getNextCHR(HolderDTO parentHolder, long offset, String prefix) throws Exception {
        try (DAOFactory df = this.daof.open();){
            Holders holders = df.getHolders();
            long count = holders.countSubHolder(parentHolder);
            String sequence = "" + (offset + count);
            String chrStr = prefix + "00000".substring(sequence.length()) + sequence + "00000";
            CertificateHolderReference chr = new CertificateHolderReference(chrStr);
            holders.newHolderForParent(parentHolder, chr.getHolder());
            CertificateHolderReference certificateHolderReference = chr;
            return certificateHolderReference;
        }
    }
}

