/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CVCertificateGenerator;
import de.cardcontact.opencard.eac.cvc.CertificateEffectiveDate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderAuthorizationTemplate;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.tlv.ObjectIdentifier;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.time.LocalDate;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.cvc.CVCertificateStore;

public class CVCCA {
    private CardVerifiableCertificate rootCACert;
    private CardVerifiableCertificate caCert;
    private SignerDTO signer;
    private CVCertificateStore store;

    public CVCCA(CVCertificateStore store, String path) throws Exception {
        this.store = store;
        this.initializeCA(path);
    }

    private void initializeCA(String path) throws Exception {
        int idx = path.lastIndexOf("/");
        String parentPath = path.substring(0, idx);
        CertificateDTO rootCACertDTO = this.store.getCurrentCertificate(parentPath);
        this.rootCACert = new CardVerifiableCertificate(rootCACertDTO.getBytes());
        HolderDTO holder = this.store.getHolder(path);
        CertificateDTO caCertDTO = this.store.getCurrentCertificate(holder);
        this.caCert = new CardVerifiableCertificate(caCertDTO.getBytes());
        this.rootCACert.verify(this.rootCACert);
        this.caCert.verify(this.rootCACert);
        this.signer = this.store.getSigner(holder, this.caCert.getCertificateHolderReference());
    }

    public CardVerifiableCertificate getCACert() {
        return this.caCert;
    }

    public CardVerifiableCertificate getRootCert() {
        return this.rootCACert;
    }

    public String getPath() {
        String path = "/" + this.rootCACert.getCertificateHolderReference().getHolder() + "/" + this.caCert.getCertificateHolderReference().getHolder();
        return path;
    }

    private String getPath(CardVerifiableCertificate cvc) {
        String path = this.getPath() + "/" + cvc.getCertificateHolderReference().getHolder();
        return path;
    }

    private PrivateKey getPrivateKey() {
        throw new RuntimeException("Not implemented");
    }

    private CardVerifiableCertificate generateCertificate(CardVerifiableCertificate req) throws GeneralSecurityException {
        CVCertificateGenerator gen = new CVCertificateGenerator();
        CertificateEffectiveDate notBefore = new CertificateEffectiveDate(LocalDate.now());
        gen.setCertificateEffectiveDate(notBefore);
        gen.setCertificateExpirationDate(this.caCert.getCVCertificate().getCertificateBody().getCertificateExpirationDate());
        CertificationAuthorityReference car = new CertificationAuthorityReference(this.caCert.getCertificateHolderReference().toString());
        gen.setCertificationAuthorityReference(car);
        gen.setCertificateHolderReference(req.getCertificateHolderReference());
        ObjectIdentifier oid = new ObjectIdentifier("1.3.6.1.4.1.24991.3.1.1");
        byte[] relativeAuthorization = new byte[2];
        CertificateHolderAuthorizationTemplate chat = new CertificateHolderAuthorizationTemplate(oid, relativeAuthorization);
        gen.setCertificateHolderAuthorizationTemplate(chat);
        oid = this.caCert.getCVCertificate().getCertificateBody().getPublicKeyTLV().getObjectIdentifier();
        gen.setPublicKey(req.getPublicKey(), oid);
        String signAlgo = CardVerifiableCertificate.signAlgoForOID((ObjectIdentifier)oid);
        PrivateKey prk = this.getPrivateKey();
        CVCertificate tlv = gen.generate(prk, signAlgo);
        CardVerifiableCertificate cvc = new CardVerifiableCertificate(tlv.getBytes());
        cvc.verify(this.caCert.getPublicKey());
        return cvc;
    }

    public CardVerifiableCertificate issueCertificate(CardVerifiableCertificate req, Long srId) throws Exception {
        CardVerifiableCertificate cvc = this.generateCertificate(req);
        String path = this.getPath(cvc);
        this.store.storeCertificate(path, cvc, true, srId);
        return cvc;
    }
}

