/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.servicerequest;

import java.lang.reflect.InvocationTargetException;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRequestFactoryBase
implements ServiceRequestFactory {
    final Logger logger = LoggerFactory.getLogger(ServiceRequestFactoryBase.class);
    Class<? extends ServiceRequest> clazz;
    String process;

    public ServiceRequestFactoryBase(Class<? extends ServiceRequest> clazz) {
        this.clazz = clazz;
        try {
            this.process = clazz.getField("PROCESS").get(clazz).toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Can not locate PROCESS field in class", e);
        }
    }

    @Override
    public String getProcess() {
        return this.process;
    }

    @Override
    public ServiceRequest getByDTO(ServiceRequestDTO dto) {
        ServiceRequest sr;
        try {
            sr = this.clazz.getDeclaredConstructor(ServiceRequestDTO.class).newInstance(dto);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error("Failed to construct service request object", (Throwable)e);
            throw new RuntimeException("Failed to construct service request object", e);
        }
        return sr;
    }
}

