/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.subject;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.SubjectDAO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.subject.Subject;
import org.openscdp.pkidm.subject.SubjectContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectGeneratorBase {
    final Logger logger = LoggerFactory.getLogger(SubjectGeneratorBase.class);
    protected SubjectDTO dto = new SubjectDTO();

    public SubjectGeneratorBase(String type) {
        this.dto.setType(type);
    }

    public void setContent(SubjectContent content) {
        String jsonstr;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            jsonstr = om.writeValueAsString((Object)content);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error setting content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
        this.dto.setContent(jsonstr);
    }

    public Subject generate() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            SubjectDAO dao = (SubjectDAO)handle.attach(SubjectDAO.class);
            dao.create(this.dto);
        }
        return PKIDMContext.getSubjectFactoryRegistry().getByDTO(this.dto);
    }
}

