/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.subject;

import java.lang.reflect.InvocationTargetException;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidm.subject.Subject;
import org.openscdp.pkidm.subject.SubjectFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectFactoryBase
implements SubjectFactory {
    final Logger logger = LoggerFactory.getLogger(SubjectFactoryBase.class);
    private Class<? extends Subject> clazz;
    private String type;

    public SubjectFactoryBase(Class<? extends Subject> clazz) {
        this.clazz = clazz;
        try {
            this.type = clazz.getField("TYPE").get(clazz).toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Can not locate TYPE field in class", e);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Subject getByDTO(SubjectDTO dto) {
        Subject subject;
        try {
            subject = this.clazz.getDeclaredConstructor(SubjectDTO.class).newInstance(dto);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.error("Failed to construct subject object", (Throwable)e);
            throw new RuntimeException("Failed to construct subject object", e);
        }
        return subject;
    }
}

