/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.subject;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.SubjectDAO;
import org.openscdp.pkidb.dto.SubjectDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.subject.Subject;
import org.openscdp.pkidm.subject.SubjectContent;
import org.openscdp.pkidm.subject.SubjectFactoryBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectBase
implements Subject {
    final Logger logger = LoggerFactory.getLogger(SubjectFactoryBase.class);
    static final ObjectMapper om = new ObjectMapper();
    protected SubjectDTO dto;

    protected SubjectBase(SubjectDTO dto) {
        this.dto = dto;
    }

    public Long getId() {
        return this.dto.getId();
    }

    protected <T extends SubjectContent> T parseContent(Class<T> clazz) {
        try {
            return (T)((SubjectContent)om.readValue(this.dto.getContent(), clazz));
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse content field", (Throwable)e);
            throw new RuntimeException("Failed to parse content field", e);
        }
    }

    public void setContent(SubjectContent content) {
        String jsonstr;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            jsonstr = om.writeValueAsString((Object)content);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error setting content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
        this.dto.setContent(jsonstr);
    }

    public void commit() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            SubjectDAO dao = (SubjectDAO)handle.attach(SubjectDAO.class);
            dao.update(this.dto);
        }
    }
}

