/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.servicerequest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.openscdp.pkidb.dao.ServiceRequestDAO;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.servicerequest.ServiceRequest;
import org.openscdp.pkidm.servicerequest.ServiceRequestContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceRequestGeneratorBase {
    final Logger logger = LoggerFactory.getLogger(ServiceRequestGeneratorBase.class);
    ServiceRequestDTO dto = new ServiceRequestDTO();

    public ServiceRequestGeneratorBase(String process, Long originatorId) {
        this.dto.setProcess(process);
        this.dto.setTitle(process);
        this.dto.setOriginatorId(originatorId);
    }

    public ServiceRequestDTO dto() {
        return this.dto;
    }

    public void setContent(ServiceRequestContent content) {
        String jsonstr;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            jsonstr = om.writeValueAsString((Object)content);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error setting content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
        this.dto.setContent(jsonstr);
    }

    public ServiceRequest generate() {
        Jdbi jdbi = PKIDMContext.getJDBI();
        try (Handle handle = jdbi.open();){
            ServiceRequestDAO dao = (ServiceRequestDAO)handle.attach(ServiceRequestDAO.class);
            dao.create(this.dto);
        }
        return PKIDMContext.getServiceRequestFactoryRegistry().getByDTO(this.dto);
    }
}

