/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.holder;

import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkidb.dao.CertificateDAO;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.X509CertificateStore;
import org.openscdp.pkidm.holder.CertificateHolder;
import org.openscdp.pkidm.signer.HSMSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertificateHolder
extends CertificateHolder {
    final Logger logger = LoggerFactory.getLogger(X509CertificateHolder.class);

    public X509CertificateHolder(HolderDTO dto) {
        super(dto);
    }

    public X509CertificateHolder getParent() {
        return super.getParent(X509CertificateHolder.class);
    }

    public X509Certificate getCurrentCertificate() {
        CertificateDTO certDTO = this.getCurrentCertificateDTO();
        if (certDTO == null) {
            return null;
        }
        try {
            return X509CertificateStore.toX509Certificate(certDTO.getBytes());
        }
        catch (CertificateException e) {
            throw new RuntimeException("Invalid certificate in database", e);
        }
    }

    public Long storeCertificate(X509Certificate cvc, boolean makeCurrent, Long srId) throws CertificateEncodingException {
        byte[] skid = X509CertificateStore.getSubjectKeyId(cvc);
        CertificateDTO certDTO = X509CertificateStore.toCertificateDTO(cvc, skid, this.getId(), srId);
        try (Handle handle = PKIDMContext.getJDBI().open();){
            CertificateDAO certDAO = (CertificateDAO)handle.attach(CertificateDAO.class);
            certDAO.create(certDTO);
            if (makeCurrent) {
                HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
                holderDAO.updateCurrentCertificate(certDTO.getId(), this.getId());
            }
        }
        return certDTO.getId();
    }

    public HSMSigner getSigner() {
        return this.getSigner(this.getCurrentKeyId());
    }

    public HSMSigner getSigner(byte[] keyId) {
        HSMSigner signer = this.getSigner(keyId, HSMSigner.class);
        return signer;
    }
}

