/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.cvc;

import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.eac.cvc.CVCertificate;
import de.cardcontact.opencard.eac.cvc.CVCertificateGenerator;
import de.cardcontact.opencard.eac.cvc.CertificateEffectiveDate;
import de.cardcontact.opencard.eac.cvc.CertificateExpirationDate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderAuthorizationTemplate;
import de.cardcontact.opencard.eac.cvc.CertificateHolderReference;
import de.cardcontact.opencard.eac.cvc.CertificationAuthorityReference;
import de.cardcontact.opencard.eac.cvc.PublicKeyReference;
import de.cardcontact.tlv.ObjectIdentifier;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Provider;
import java.time.LocalDate;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.cvc.CVCCAPolicy;
import org.openscdp.pkidm.cvc.CVCSigner;
import org.openscdp.pkidm.holder.CVCertificateHolder;

public class CVCIssuer
extends CVCSigner {
    protected CVCCAPolicy policy;
    protected CardVerifiableCertificate cert;
    protected CVCertificateHolder holder;
    protected Long serviceRequestId;

    public CVCIssuer(SignerDTO dto) {
        super(dto);
    }

    public CardVerifiableCertificate getCertificate() {
        return this.cert;
    }

    public PublicKeyReference getCHR() {
        return new CertificateHolderReference(this.holder.getName() + "00000");
    }

    public CardVerifiableCertificate issueCertificate(CardVerifiableCertificate request) throws GeneralSecurityException {
        CVCertificateGenerator gen = new CVCertificateGenerator((Provider)this.getProvider());
        CertificateEffectiveDate notBefore = new CertificateEffectiveDate(LocalDate.now());
        gen.setCertificateEffectiveDate(notBefore);
        LocalDate notAfter = LocalDate.now().plusDays(this.policy.getCertificateValidityDays());
        LocalDate dicaNotAfter = this.cert.getCertificateExpirationDate();
        if (notAfter.isAfter(dicaNotAfter)) {
            notAfter = dicaNotAfter;
        }
        CertificateExpirationDate cxd = new CertificateExpirationDate(notAfter);
        gen.setCertificateExpirationDate(cxd);
        CertificationAuthorityReference car = new CertificationAuthorityReference(this.cert.getCertificateHolderReference().toString());
        gen.setCertificationAuthorityReference(car);
        gen.setCertificateHolderReference(request.getCertificateHolderReference());
        ObjectIdentifier oid = this.cert.getCertificateHolderAuthorizationTemplate().getOID();
        byte[] relativeAuthorization = new byte[1];
        CertificateHolderAuthorizationTemplate chat = new CertificateHolderAuthorizationTemplate(oid, relativeAuthorization);
        gen.setCertificateHolderAuthorizationTemplate(chat);
        gen.setPublicKey(request.getPublicKey(), this.cert.getPublicKeyOID());
        String signAlgo = CardVerifiableCertificate.signAlgoForOID((ObjectIdentifier)this.cert.getPublicKeyOID());
        CVCertificate tlv = gen.generate((PrivateKey)this.getKey(), signAlgo);
        CardVerifiableCertificate cvc = new CardVerifiableCertificate(tlv.getBytes());
        this.holder.storeCertificate(cvc, true, this.serviceRequestId);
        return cvc;
    }
}

