/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidm.signer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.openscdp.pkidb.dto.SignerDTO;
import org.openscdp.pkidm.signer.Signer;
import org.openscdp.pkidm.signer.SignerContent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignerBase
implements Signer {
    final Logger logger = LoggerFactory.getLogger(SignerBase.class);
    static final ObjectMapper om = new ObjectMapper();
    protected SignerDTO dto;

    public SignerBase(SignerDTO dto) {
        this.dto = dto;
    }

    protected <T extends SignerContent> T parseContent(Class<T> clazz) {
        try {
            return (T)((SignerContent)om.readValue(this.dto.getContent(), clazz));
        }
        catch (JsonProcessingException e) {
            this.logger.error("Failed to parse content field", (Throwable)e);
            throw new RuntimeException("Failed to parse content field", e);
        }
    }

    public void setContent(SignerContent content) {
        String jsonstr;
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            jsonstr = om.writeValueAsString((Object)content);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Error setting content", (Throwable)e);
            throw new RuntimeException("Error setting content", e);
        }
        this.dto.setContent(jsonstr);
    }
}

