/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.dao;

import java.util.List;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openscdp.pkidb.dto.HolderDTO;

@RegisterBeanMapper(value=HolderDTO.class)
public interface HolderDAO
extends SqlObject {
    @SqlUpdate(value="INSERT INTO Holder (certificateType, parentId, name, subjectId, signerNo, certId) VALUES(:certificateType, :parentId, :name, :subjectId, :signerNo, :certId)")
    @GetGeneratedKeys(value={"id"})
    public Long insert(@BindBean HolderDTO var1);

    default public HolderDTO create(HolderDTO holder) {
        Long id = this.insert(holder);
        holder.setId(id);
        return holder;
    }

    @SqlUpdate(value="UPDATE Holder SET certId = ? WHERE id = ?")
    public void updateCurrentCertificate(Long var1, Long var2);

    @SqlQuery(value="SELECT * FROM Holder WHERE subjectId = ?")
    public List<HolderDTO> getHolderListBySubject(Long var1);

    @SqlQuery(value="SELECT * FROM Holder WHERE id = ?")
    public HolderDTO getHolder(Long var1);

    @SqlQuery(value="SELECT id FROM Holder WHERE certificateType = ? AND parentId IS NULL AND name = ?")
    public Long getRootHolderId(int var1, String var2);

    @SqlQuery(value="SELECT id FROM Holder WHERE certificateType = ? AND parentId = ? AND name = ?")
    public Long getHolderId(int var1, Long var2, String var3);

    @SqlQuery(value="SELECT * FROM Holder WHERE certificateType = ? AND parentId = ? AND subjectId = ?")
    public List<Long> getHolderIds(int var1, Long var2, Long var3);

    @SqlQuery(value="SELECT * FROM Holder WHERE subjectId = ? AND type = ?")
    public List<HolderDTO> getHolderListBySubjectAndType(Long var1, String var2);

    default public Long getHolderId(int certificateType, Long parentId, Long subjectId) throws Exception {
        List<Long> ids = this.getHolderIds(certificateType, parentId, subjectId);
        if (ids.size() > 1) {
            throw new Exception("The tuple (certificateType, parentId, subjectId) with values (" + certificateType + ", " + parentId + ", " + subjectId + ") is not unique");
        }
        if (ids.size() == 0) {
            return null;
        }
        return ids.get(0);
    }

    default public Long determineId(String path, int certificateType) throws Exception {
        String[] elements = path.substring(1).split("/");
        if (path.indexOf("/") == -1) {
            throw new Exception("Invalid path argument: " + path);
        }
        Long id = this.getRootHolderId(certificateType, elements[0]);
        if (id == null) {
            return id;
        }
        for (int i = 1; i < elements.length; ++i) {
            id = this.getHolderId(certificateType, id, elements[i]);
        }
        return id;
    }

    @SqlQuery(value="SELECT count(1) FROM Holder WHERE parentId = ?")
    public Long countSubHolder(Long var1);
}

