/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.dao;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Update;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openscdp.pkidb.dto.ServiceRequestDTO;
import org.openscdp.pkidb.dto.ServiceRequestStateDTO;

@RegisterBeanMapper(value=ServiceRequestDTO.class)
public interface ServiceRequestDAO
extends SqlObject {
    @SqlUpdate(value="INSERT INTO ServiceRequest (parentServiceRequestId, process, title, details, state, originatorId, recipientId, messageId, assignedToRole, due, content) VALUES (:parentServiceRequestId, :process, :title, :details, :state, :originatorId, :recipientId, :messageId, :assignedToRole, :due, :content)")
    @GetGeneratedKeys(value={"id"})
    public Long insert(@BindBean ServiceRequestDTO var1);

    default public ServiceRequestDTO create(ServiceRequestDTO sr) {
        Long id = this.insert(sr);
        sr.setId(id);
        return sr;
    }

    @SqlUpdate(value="UPDATE ServiceRequest SET parentServiceRequestId = :parentServiceRequestId, process = :process, title = :title, details = :details, state = :state, lifecycle = :lifecycle, originatorId = :originatorId, recipientId = :recipientId, messageId = :messageId, assignedToRole = :assignedToRole, due = :due, content = :content WHERE id = :id")
    public void update(@BindBean ServiceRequestDTO var1);

    @SqlUpdate(value="UPDATE ServiceRequest SET messageId = ?")
    public void updateMessageId(String var1);

    @SqlQuery(value="SELECT * FROM ServiceRequest WHERE id = ?")
    public ServiceRequestDTO getServiceRequest(Long var1);

    @SqlQuery(value="SELECT * FROM ServiceRequest WHERE originatorId = ? and recipientId = ? and process = ?")
    public ServiceRequestDTO getServiceRequestLink(Long var1, Long var2, String var3);

    @SqlQuery(value="SELECT * FROM ServiceRequest WHERE messageId like ?")
    public ServiceRequestDTO getServiceRequestByMessageId(String var1);

    default public void addLifeCycleTransition(ServiceRequestDTO sr, Long caseHandlerSubjectId, String content) {
        Handle handle = this.getHandle();
        handle.begin();
        Long id = (Long)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate("INSERT INTO ServiceRequestState (serviceRequestId, lifecycle, state, caseHandlerId, caseHandlerRole, content) VALUES (?, ?, ?, ?, ?, ?)").bind(0, sr.getId())).bind(1, sr.getLifecycle())).bind(2, sr.getState())).bind(3, caseHandlerSubjectId)).bind(4, sr.getAssignedToRole())).bind(5, content)).executeAndReturnGeneratedKeys(new String[]{"id"}).mapTo(Long.class).one();
        ((Update)((Update)((Update)((Update)((Update)handle.createUpdate("UPDATE ServiceRequest SET state = ?, lifecycle = ?, assignedToRole = ?, content = ? WHERE id = ?").bind(0, sr.getState())).bind(1, sr.getLifecycle())).bind(2, sr.getAssignedToRole())).bind(3, sr.getContent())).bind(4, sr.getId())).execute();
        handle.commit();
    }

    @SqlQuery(value="SELECT * FROM ServiceRequestState WHERE serviceRequestId = ?")
    @RegisterBeanMapper(value=ServiceRequestStateDTO.class)
    public List<ServiceRequestStateDTO> listServiceRequestStates(long var1);
}

