/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.jdbi;

import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;

public class Util {
    public static String createCertificate = "CREATE TABLE IF NOT EXISTS Certificate (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\tholderId MEDIUMINT UNSIGNED NOT NULL REFERENCES Holder(id),\tserviceRequestId MEDIUMINT UNSIGNED REFERENCES ServiceRequest(id),\texpiry BIGINT,\tstatus SMALLINT NOT NULL DEFAULT 0,\trevocationDate TIMESTAMP NULL,\tinvalidityDate TIMESTAMP NULL,\tserial VARCHAR(100) NOT NULL,\tlinkDir SMALLINT NOT NULL,\tkeyId VARBINARY(64),\tbytes VARBINARY(8192) NOT NULL,\tPRIMARY KEY (id),\tUNIQUE (holderId, serial, linkDir),\tFOREIGN KEY (holderId) REFERENCES Holder(id) ON DELETE CASCADE)";
    public static String createConfiguration = "CREATE TABLE IF NOT EXISTS Configuration (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\tname VARCHAR(250),\tcontent LONGTEXT,\tPRIMARY KEY (id))";
    public static String createHolder = "CREATE TABLE IF NOT EXISTS Holder (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\tcertificateType SMALLINT UNSIGNED NOT NULL,\tparentId MEDIUMINT UNSIGNED,\tname VARCHAR(100),\tsubjectId MEDIUMINT UNSIGNED REFERENCES Subject(id),\tsignerNo MEDIUMINT UNSIGNED,\tcertId MEDIUMINT UNSIGNED,\tUNIQUE (certificateType, parentId, name),\tPRIMARY KEY (id),\tFOREIGN KEY (parentId) REFERENCES Holder(id) ON DELETE CASCADE,\tFOREIGN KEY (subjectId) REFERENCES Subject(id) ON DELETE SET NULL)";
    public static String createRequest = "CREATE TABLE IF NOT EXISTS Request (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\tholderId MEDIUMINT UNSIGNED NOT NULL REFERENCES Holder(id),\tkeyId VARBINARY(64) NOT NULL,\tbytes VARBINARY(4096) NOT NULL,\tPRIMARY KEY (id),\tFOREIGN KEY (holderId) REFERENCES Holder(id) ON DELETE CASCADE)";
    public static String createRole = "CREATE TABLE IF NOT EXISTS Role (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\tname VARCHAR(100) NOT NULL,\tmanagingRoleId MEDIUMINT UNSIGNED REFERENCES Role(id),\trequiresApproval SMALLINT NOT NULL DEFAULT 0,\tPRIMARY KEY (id),\tUNIQUE (name));";
    public static String createAssignedRole = "CREATE TABLE IF NOT EXISTS AssignedRole (\tsubjectId MEDIUMINT UNSIGNED NOT NULL REFERENCES Subject(id),\troleId MEDIUMINT UNSIGNED NOT NULL REFERENCES Role(id),\tserviceRequestId MEDIUMINT UNSIGNED REFERENCES ServiceRequest(id),\tPRIMARY KEY (subjectId, roleId));";
    public static String createServiceRequest = "CREATE TABLE IF NOT EXISTS ServiceRequest (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\tparentServiceRequestId MEDIUMINT UNSIGNED REFERENCES ServiceRequest(id),\tprocess VARCHAR(250),\ttitle VARCHAR(250),\tdetails VARCHAR(250),\tstate VARCHAR(250),\tlifecycle MEDIUMINT NOT NULL DEFAULT 1,\toriginatorId MEDIUMINT UNSIGNED REFERENCES Subject(id),\trecipientId MEDIUMINT UNSIGNED REFERENCES Subject(id),\tmessageId VARCHAR(250),\tassignedToRole MEDIUMINT UNSIGNED REFERENCES Role(id),\tcreated TIMESTAMP DEFAULT NOW(),\tdue TIMESTAMP NULL,\tcontent LONGTEXT,\tPRIMARY KEY (id),\tFOREIGN KEY (parentServiceRequestId) REFERENCES ServiceRequest(id),\tFOREIGN KEY (originatorId) REFERENCES Subject(id),\tFOREIGN KEY (recipientId) REFERENCES Subject(id))";
    public static String createServiceRequestState = "CREATE TABLE IF NOT EXISTS ServiceRequestState (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\tserviceRequestId MEDIUMINT UNSIGNED REFERENCES ServiceRequest(id),\tlifecycle MEDIUMINT NOT NULL,\tstate VARCHAR(250),\ttransitionTime TIMESTAMP DEFAULT NOW(),\tcaseHandlerId MEDIUMINT UNSIGNED REFERENCES Subject(id),\tcontent LONGTEXT,\tPRIMARY KEY (id),\tFOREIGN KEY (serviceRequestId) REFERENCES ServiceRequest(id),\tFOREIGN KEY (caseHandlerId) REFERENCES Subject(id))";
    public static String createSigner = "CREATE TABLE IF NOT EXISTS Signer (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\tholderId MEDIUMINT UNSIGNED NOT NULL REFERENCES Holder(id),\tname VARCHAR(100) NOT NULL,\tkeyId VARBINARY(64),\tkeyDomain VARBINARY(32),\tkeyblob VARBINARY(4096),\tcontent LONGTEXT,\tPRIMARY KEY (id),\tUNIQUE (holderId, name),\tFOREIGN KEY (holderId) REFERENCES Holder(id) ON DELETE CASCADE)";
    public static String createSubject = "CREATE TABLE IF NOT EXISTS Subject (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\temail VARCHAR(100),\tname VARCHAR(100),\ttype VARCHAR(20),\tassuranceLevel MEDIUMINT UNSIGNED NOT NULL DEFAULT 0,\tmanagedByRoleId MEDIUMINT UNSIGNED REFERENCES Role(id),\tlifecycle MEDIUMINT UNSIGNED NOT NULL DEFAULT 0,\tserviceRequestId MEDIUMINT UNSIGNED,\tcontent LONGTEXT,\tPRIMARY KEY (id),\tUNIQUE (email),\tUNIQUE (type, name))";
    public static String addSubjectForeignKey = "ALTER TABLE Subject ADD CONSTRAINT Subject_FK FOREIGN KEY IF NOT EXISTS (serviceRequestId) REFERENCES ServiceRequest(id);";
    public static String dropSubjectForeignKey = "ALTER TABLE Subject DROP FOREIGN KEY IF EXISTS Subject_FK";
    public static String createToken = "CREATE TABLE IF NOT EXISTS Token (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\tpath VARCHAR(100) NOT NULL,\tsubjectId MEDIUMINT UNSIGNED REFERENCES Subject(id),\tlastSeen TIMESTAMP DEFAULT NOW(),\tkeyDomain VARBINARY(20),\tserviceRequestId MEDIUMINT UNSIGNED REFERENCES ServiceRequest(id),\tPRIMARY KEY (id),\tunique (path),\tFOREIGN KEY (serviceRequestId) REFERENCES ServiceRequest(id) ON DELETE SET NULL,\tFOREIGN KEY (subjectId) REFERENCES Subject(id) ON DELETE SET NULL)";
    public static String createTokenAction = "CREATE TABLE IF NOT EXISTS TokenAction (\tid MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT,\ttokenId MEDIUMINT UNSIGNED REFERENCES Token(id),\tserviceRequestId MEDIUMINT UNSIGNED REFERENCES ServiceRequest(id),\tPRIMARY KEY (id),\tFOREIGN KEY (tokenId) REFERENCES Token(id) ON DELETE CASCADE,\tFOREIGN KEY (serviceRequestId) REFERENCES ServiceRequest(id) ON DELETE CASCADE)";

    public static void recreateTables(Jdbi jdbi) {
        try (Handle handle = jdbi.open();){
            try {
                handle.execute("SET FOREIGN_KEY_CHECKS=0;", new Object[0]);
            }
            catch (UnableToExecuteStatementException unableToExecuteStatementException) {
                // empty catch block
            }
            handle.execute("DROP TABLE IF EXISTS TokenAction, Token, Configuration, Certificate, ServiceRequestState, ServiceRequest, Request, Signer, Holder, AssignedRole, Subject, Role", new Object[0]);
            handle.execute(createRole, new Object[0]);
            handle.execute(createSubject, new Object[0]);
            handle.execute(createHolder, new Object[0]);
            handle.execute(createSigner, new Object[0]);
            handle.execute(createRequest, new Object[0]);
            handle.execute(createServiceRequest, new Object[0]);
            handle.execute(createServiceRequestState, new Object[0]);
            handle.execute(createAssignedRole, new Object[0]);
            handle.execute(createCertificate, new Object[0]);
            handle.execute(createConfiguration, new Object[0]);
            handle.execute(createToken, new Object[0]);
            handle.execute(createTokenAction, new Object[0]);
            handle.execute("SET FOREIGN_KEY_CHECKS=1;", new Object[0]);
        }
    }
}

