/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.jdbi;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.naming.ConfigurationException;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbiFactory {
    private static final Logger logger = LoggerFactory.getLogger(JdbiFactory.class);
    public static final String PROPERTIES_FILE = "pkidb.properties";

    private static Jdbi create() {
        String propertiesPath = System.getProperty(PROPERTIES_FILE);
        Properties properties = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(propertiesPath));
            properties.load(in);
        }
        catch (IOException e) {
            logger.error("Failed loading pkidb properties from path " + propertiesPath, (Throwable)e);
            return null;
        }
        Jdbi jdbi = Jdbi.create((String)properties.getProperty("url"), (String)properties.getProperty("userName"), (String)properties.getProperty("password"));
        jdbi.installPlugin((JdbiPlugin)new SqlObjectPlugin());
        return jdbi;
    }

    private JdbiFactory() {
    }

    public static Jdbi getInstance() throws ConfigurationException {
        if (JdbiLoader.INSTANCE == null) {
            throw new ConfigurationException("Initialization failed");
        }
        return JdbiLoader.INSTANCE;
    }

    private static class JdbiLoader {
        private static final Jdbi INSTANCE = JdbiFactory.create();

        private JdbiLoader() {
        }
    }
}

