/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkidb.dao;

import java.util.List;
import org.jdbi.v3.sqlobject.SqlObject;
import org.jdbi.v3.sqlobject.config.RegisterBeanMapper;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;
import org.openscdp.pkidb.dto.CertificateDTO;

@RegisterBeanMapper(value=CertificateDTO.class)
public interface CertificateDAO
extends SqlObject {
    @SqlUpdate(value="INSERT INTO Certificate (holderId, serviceRequestId, expiry, status, revocationDate, invalidityDate, serial, linkDir, keyId, bytes) VALUES(:holderId, :serviceRequestId, :expiry, :status, :revocationDate, :invalidityDate, :serial, :linkDir, :keyId, :bytes)")
    @GetGeneratedKeys(value={"id"})
    public Long insert(@BindBean CertificateDTO var1);

    default public Long create(CertificateDTO cert) {
        Long id = this.insert(cert);
        cert.setId(id);
        return id;
    }

    @SqlQuery(value="SELECT * FROM Certificate WHERE id = ?")
    public CertificateDTO getCertificate(Long var1);

    @SqlQuery(value="SELECT * FROM Certificate WHERE keyId = ?")
    public List<CertificateDTO> getCertificateByKeyId(byte[] var1);

    @SqlQuery(value="SELECT * FROM Certificate WHERE holderId = ? and keyId = ?")
    public List<CertificateDTO> getCertificateByHolderAndKeyId(Long var1, byte[] var2);

    @SqlQuery(value="SELECT * FROM Certificate WHERE keyId = ? AND serial = ?")
    public CertificateDTO getCertificateByKeyIdAndSerial(byte[] var1, String var2);

    @SqlQuery(value="SELECT * FROM Certificate WHERE serviceRequestId = ?")
    public List<CertificateDTO> getCertificateByServiceRequestId(Long var1);

    @SqlUpdate(value="UPDATE Certificate SET status = ? WHERE id = ?")
    public void updateStatus(int var1, Long var2);
}

