/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.kdm;

import de.cardcontact.opencard.service.smartcardhsm.KeyDomain;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.HexString;
import java.util.List;
import opencard.core.OpenCardException;
import org.openscdp.pkicard.ServiceRequestSmartCardHSMAction;
import org.openscdp.pkicard.kdm.IssueKeyDomainMembership;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.json.JSONActionResult;
import org.openscdp.pkihsmsrv.HSMService;

public class DeleteKeyDomainAction
extends ServiceRequestSmartCardHSMAction {
    public static final String ACTION = "action.kess.kdm.deletekd";
    private IssueKeyDomainMembership sr;

    public DeleteKeyDomainAction(IssueKeyDomainMembership serviceRequest) {
        super(ACTION, serviceRequest);
        this.sr = serviceRequest;
        String lastSeenAt = serviceRequest.getBackendConnectedTo();
        if (lastSeenAt != null) {
            this.context = "@" + lastSeenAt;
        }
    }

    private void deleteKeyDomain(SmartCardHSMProvider provider) throws OpenCardException {
        SmartCardHSMCardService service = provider.getSmartCardHSMCardService();
        List kds = service.getKeyDomains();
        for (KeyDomain kd : kds) {
            String uid;
            if (kd.getKeyDomainUID() == null || !(uid = HexString.hexifyByteArray((byte[])kd.getKeyDomainUID())).equals(this.sr.getContent().keyDomainUID)) continue;
            if (!service.deleteKeyDomain(kd)) {
                throw new ServiceRequestActionException("Failed to delete key domain. Is it empty ?");
            }
            return;
        }
    }

    @Override
    public JSONActionResult execute() {
        IssueKeyDomainMembership sr = (IssueKeyDomainMembership)this.serviceRequest;
        String lastSeenAt = sr.getBackendConnectedTo();
        if (lastSeenAt == null) {
            return this.getStatus();
        }
        return this.execute(sr.getContent().getTokenPath());
    }

    @Override
    protected void postProcessForHSMServiceToken(SmartCardHSMProvider provider) {
        HSMService hsmService = PKIDMContext.getHSMService();
        IssueKeyDomainMembership sr = (IssueKeyDomainMembership)this.serviceRequest;
        byte[] uid = HexString.parseHexString((String)sr.getContent().keyDomainUID);
        String id = null;
        try {
            id = provider.getSmartCardHSMCardService().getId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        hsmService.removeKeyDomainMapping(uid, id);
    }

    @Override
    public void execute(SmartCardHSMProvider provider) {
        try {
            this.deleteKeyDomain(provider);
            this.setDetail("Key Domain deleted");
            this.serviceRequest.setStatusInfo(this.getDetail());
            this.serviceRequest.setLifeCycle(12);
        }
        catch (ServiceRequestActionException srae) {
            throw srae;
        }
        catch (Exception e) {
            throw new ServiceRequestActionException(e.getMessage(), (Throwable)e);
        }
    }
}

