/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard.groupsigner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import de.cardcontact.opencard.eac.CardVerifiableCertificate;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.Key;
import java.security.cert.CertPathBuilderException;
import java.security.cert.Certificate;
import java.util.Enumeration;
import opencard.core.OpenCardException;
import org.jdbi.v3.core.Handle;
import org.openscdp.pkicard.cvc.CreateCVCSignerSmartCardHSMAction;
import org.openscdp.pkicard.groupsigner.CreateGroupSharedServiceRequest;
import org.openscdp.pkicard.groupsigner.CreateSignerContent;
import org.openscdp.pkidb.dao.HolderDAO;
import org.openscdp.pkidb.dto.CertificateDTO;
import org.openscdp.pkidb.dto.HolderDTO;
import org.openscdp.pkidm.PKIDMContext;
import org.openscdp.pkidm.action.ServiceRequestActionException;
import org.openscdp.pkidm.cvc.CVCTools;
import org.openscdp.pkidm.cvc.importer.SCHSMTokenCertificateImporter;
import org.openscdp.pkidm.holder.escrow.GroupSignerContent;
import org.openscdp.pkidm.json.JSONKeyDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGroupSignerAction
extends CreateCVCSignerSmartCardHSMAction<CreateGroupSharedServiceRequest> {
    private final Logger logger = LoggerFactory.getLogger(CreateGroupSignerAction.class);
    public static final String ACTION = "action.signer.create";
    private CreateSignerContent content;
    private String grouplabel;
    private String importedSigner = null;

    public CreateGroupSignerAction(CreateGroupSharedServiceRequest serviceRequest) {
        super(ACTION, serviceRequest);
    }

    public String getKey() {
        return ACTION;
    }

    @Override
    public boolean preFlightCheck() {
        this.content = ((CreateGroupSharedServiceRequest)this.serviceRequest).getContent();
        this.tokenPath = ((CreateGroupSharedServiceRequest)this.serviceRequest).getTokenPath();
        if (this.tokenPath == null) {
            return false;
        }
        JSONKeyDomain kd = ((CreateGroupSharedServiceRequest)this.serviceRequest).getKeyDomain();
        if (kd == null) {
            return false;
        }
        this.keyDomainUID = kd.uid;
        this.issuerId = this.getCertificateHolderId(this.tokenPath);
        if (this.issuerId == null) {
            return false;
        }
        this.holderName = this.content.getHolderName();
        if (this.holderName.length() == 0) {
            return false;
        }
        this.grouplabel = this.content.getLabel();
        return this.grouplabel != null;
    }

    private SmartCardHSMPrivateKey findGroupSigner() throws Exception {
        String[] parts;
        SmartCardHSMPrivateKey prk = null;
        Enumeration<String> aliases = this.keyStore.aliases();
        String alias = null;
        while (aliases.hasMoreElements() && ((parts = (alias = aliases.nextElement()).split("/")).length != 4 || !parts[3].equals(this.holderName + "00001"))) {
            alias = null;
        }
        if (alias == null) {
            this.logger.info("No existing key found matching group name");
            return null;
        }
        Key key = this.keyStore.getKey(alias, null);
        if (!(key instanceof SmartCardHSMPrivateKey)) {
            this.logger.error("Key matching group name is not a private key");
            return null;
        }
        prk = (SmartCardHSMPrivateKey)key;
        Certificate[] chain = this.keyStore.getCertificateChain(alias);
        if (chain.length != 3) {
            this.logger.error("Key does not have a certificate chain");
            return null;
        }
        CardVerifiableCertificate devCert = (CardVerifiableCertificate)chain[1];
        CardVerifiableCertificate dicaCert = (CardVerifiableCertificate)chain[2];
        String path = "/" + dicaCert.getCertificationAuthorityReference().getHolder() + "/" + dicaCert.getCertificateHolderReference().getHolder() + "/" + devCert.getCertificateHolderReference().getHolder();
        Long id = this.getCertificateHolderId(path);
        if (id == null) {
            CertificateDTO dto;
            path = "/" + dicaCert.getCertificationAuthorityReference().getHolder() + "/" + dicaCert.getCertificateHolderReference().getHolder();
            id = this.getCertificateHolderId(path);
            if (id == null) {
                path = "/" + dicaCert.getCertificationAuthorityReference().getHolder();
                id = this.getCertificateHolderId(path);
                if (id == null) {
                    this.logger.error("Device issuer certificate can not be inserted");
                    return null;
                }
                dto = CVCTools.importCertificate((CardVerifiableCertificate)dicaCert, (Long)id, (String)"DICA");
                id = dto.getHolderId();
            }
            dto = CVCTools.importCertificate((CardVerifiableCertificate)devCert, (Long)id, null);
            id = dto.getHolderId();
        }
        this.issuerId = id;
        this.importedSigner = alias;
        return prk;
    }

    @Override
    protected SmartCardHSMPrivateKey reuseKey() throws Exception {
        SmartCardHSMPrivateKey prk = this.findGroupSigner();
        this.getHolder();
        return prk;
    }

    public Long getCertificateHolderId(String tokenPath) {
        Long l;
        block8: {
            Handle handle = PKIDMContext.getJDBI().open();
            try {
                Long deviceCertHolderId;
                HolderDAO holderDAO = (HolderDAO)handle.attach(HolderDAO.class);
                l = deviceCertHolderId = holderDAO.determineId(tokenPath, 1);
                if (handle == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            handle.close();
        }
        return l;
    }

    @Override
    protected void amendNewHolder(HolderDTO dto) {
        String jsonstr;
        dto.setSubjectId(((CreateGroupSharedServiceRequest)this.serviceRequest).getRecipientId());
        dto.setType("GroupSigner");
        GroupSignerContent gsContent = new GroupSignerContent();
        gsContent.label = this.grouplabel;
        gsContent.backend = ((CreateGroupSharedServiceRequest)this.serviceRequest).getBackendConnectedTo();
        ObjectMapper om = new ObjectMapper();
        om.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            jsonstr = om.writeValueAsString((Object)gsContent);
        }
        catch (JsonProcessingException e) {
            throw new ServiceRequestActionException("Error setting content", (Throwable)e);
        }
        dto.setContent(jsonstr);
    }

    @Override
    protected String getCurve() {
        return "brainpoolP256r1";
    }

    @Override
    protected void postProcess() throws Exception {
        this.holder.storeCertificate(this.atreq, true, ((CreateGroupSharedServiceRequest)this.serviceRequest).getId());
        this.content.holderId = this.holder.getId();
        if (this.importedSigner != null) {
            ((CreateGroupSharedServiceRequest)this.serviceRequest).setStatusInfo("Group Signer recreated from " + this.importedSigner);
        } else {
            ((CreateGroupSharedServiceRequest)this.serviceRequest).setStatusInfo("New Group Signer generated");
        }
        ((CreateGroupSharedServiceRequest)this.serviceRequest).setLifeCycle(11);
        ((CreateGroupSharedServiceRequest)this.serviceRequest).setRoleId(null);
    }

    @Override
    protected void postProcessForHSMServiceToken(SmartCardHSMProvider provider) {
        SCHSMTokenCertificateImporter importer = new SCHSMTokenCertificateImporter(((CreateGroupSharedServiceRequest)this.serviceRequest).getBackendConnectedTo());
        try {
            importer.importDeviceChain(provider.getSmartCardHSMCardService());
        }
        catch (CertPathBuilderException | OpenCardException e) {
            this.logger.error("Signer creation failed", e);
            ((CreateGroupSharedServiceRequest)this.serviceRequest).setStatusInfo("Creation failed");
            throw new ServiceRequestActionException(e.getMessage(), e);
        }
    }
}

