/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.pkicard;

import de.cardcontact.opencard.terminal.remoteterminal.RemoteTerminal;
import opencard.core.OpenCardException;
import opencard.core.event.CardTerminalEvent;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminal;
import opencard.core.util.APDUTracer;
import opencard.core.util.SLF4JAPDUTracer;
import org.openscdp.pkicard.ServiceRequestCardAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRequestCardActionExecutor
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ServiceRequestCardActionExecutor.class);
    private SLF4JAPDUTracer apduTracer = new SLF4JAPDUTracer();
    private RemoteTerminal rt;
    private ServiceRequestCardAction sr;

    public ServiceRequestCardActionExecutor(RemoteTerminal rt, ServiceRequestCardAction sr) {
        this.rt = rt;
        this.sr = sr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.debug("Card operation started.");
        SmartCard card = null;
        try {
            CardTerminalEvent ctevent = new CardTerminalEvent((CardTerminal)this.rt, 1, 0);
            card = SmartCard.getSmartCard((CardTerminalEvent)ctevent, null, null);
            card.setAPDUTracer((APDUTracer)this.apduTracer);
            this.sr.execute(card);
            this.rt.sendNotification(0, "OK", 0);
        }
        catch (Exception e) {
            this.logger.error("Card operation failed", (Throwable)e);
            try {
                this.rt.sendNotification(0, e.getMessage(), -1);
            }
            catch (OpenCardException e2) {
                this.logger.error("Sending notification failed", (Throwable)e2);
            }
        }
        finally {
            if (card != null) {
                try {
                    card.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

