/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2020 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview TrustCenterController
 */

var ServiceRequestModel	= require('pki-as-a-service/service/ServiceRequestModel').ServiceRequestModel;



function TrustCenterController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new TrustCenterController()");
}

exports.TrustCenterController = TrustCenterController;



TrustCenterController.prototype.getView = function(req, res, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var div = <div />;

	var homeURL = subjectController.ui.homeURL(req.url);

	div.appendChild( <h2>{subject.getName()}</h2> );

	div.appendChild(subjectController.renderHolderViews(subject, homeURL));

	var certTable = subjectController.renderCertificate(subject, homeURL);
	if (certTable) {
		div.appendChild( <h2>CA Certificates</h2> );
		div.appendChild(certTable);
	}

	div.appendChild( <h2>Token</h2> );
	div.appendChild(subjectController.renderToken(subject, homeURL));

	var joins = this.getJoinESTServerServiceRequests(subjectController, subject);
	if (joins.length > 0) {
		var estServer = <div><ul/></div>;
		for (var i = 0; i < joins.length; i++) {
			var sr = joins[i];
			if (sr.details) {
				var title = sr.details + " (" + ServiceRequestModel.getLifeCycleStringForId(sr.lifecycle) + ")";
			} else {
				var title = "Pending Service Request (" + ServiceRequestModel.getLifeCycleStringForId(sr.lifecycle) + ")";
			}
			estServer.ul.li += <li><a href={homeURL + "/sr/" + sr.id}>{ title }</a></li>;

		}
		div.appendChild( <h2>EST-Server</h2> );
		div.appendChild(estServer);
	}

	var trustedCerts = subject.getTrustedCertificates();
	if (trustedCerts.length > 0) {
		var trustedCertsDiv = <div><ul/></div>;
		for (var i = 0; i < trustedCerts.length; i++) {
			var certId = trustedCerts[i];

			var certDAO = subjectController.service.daof.getCertificateDAO();
			var cert = certDAO.getCertificateById(certId);

			var holderDAO = subjectController.service.daof.getHolderDAO();
			var holder = holderDAO.getHolderById(cert.holderId);
			trustedCertsDiv.ul.li += <li><a href={homeURL + "/cert/" + cert.id}>{ holder.name }</a></li>;
		}
		div.appendChild( <h2>Trusted Certificates</h2> );
		div.appendChild(trustedCertsDiv);
	}

	var roles = <div><ul/></div>;
	if (subject.bo.managedByRoleId != null) {
		roles.ul.li += <li><a href={homeURL + "/role/" + subject.bo.managedByRoleId}>TrustCenter Operator</a></li>;
	}
	if (subject.getManagerRoleId()) {
		roles.ul.li += <li><a href={homeURL + "/role/" + subject.getManagerRoleId()}>TrustCenter Manager</a></li>;
	}
	if (subject.getRARoleId()) {
		roles.ul.li += <li><a href={homeURL + "/role/" + subject.getRARoleId()}>Registration Officer</a></li>;
	}
	if (subject.getCARoleId()) {
		roles.ul.li += <li><a href={homeURL + "/role/" + subject.getCARoleId()}>Certification Officer</a></li>;
	}
	if (roles.ul.length() > 0) {
		div.appendChild( <h2>Roles</h2> );
		div.appendChild(roles);
	}

	return div;
}



TrustCenterController.prototype.getJoinESTServerServiceRequests = function(subjectController, subject) {
	var filter = {
		originatorId: subject.getId(),
		process: "JoinESTServerServiceRequest"
	};

	var srDAO = subjectController.service.daof.getServiceRequestDAO();
	var result = srDAO.listServiceRequestsByFilter(filter);

	return result;
}



TrustCenterController.prototype.getMenuModel = function(req, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var homeURL = subjectController.ui.homeURL(req.url);
	var model = subjectController.getMenuModelFromRegistry("CA", subject, homeURL);

	if (model.hasChildren) {
		return model;
	}
}



TrustCenterController.prototype.restfulGET = function(req, res, subjectController, subject) {
	var url = req.url[3];
	GPSystem.log(GPSystem.DEBUG, module.id, "restfulGET for " + url);

	if (url == "dica") {
		var o = {
			id: subject.getId(),
			type: subject.getType(),
			name: subject.getName(),
			dica: [
			]
		};

		var holder = subject.getHolderList();
		for (var i = 0; i < holder.length; i++) {
			if (holder[i].type == "DICA") {
				o.dica.push( { label: holder[i].name, id: holder[i].id } );
			}
		}

		var str = JSON.stringify(o, null, "\t");

		res.setContentType("application/json");
		res.setStatus(HttpResponse.SC_OK);
		res.println(str);
	} else {
		res.setContentType("application/json");
		res.setStatus(HttpResponse.SC_NOT_FOUND);
	}
}
