/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2023 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for issuing a Key Domain Membership
 */

var I18N = require('scsh/srv-cc1/I18N').I18N;
var BackendServiceRequestControllerBase = require('pki-as-a-service/ui/BackendServiceRequestControllerBase').BackendServiceRequestControllerBase;



I18N.addResources([
 	{ lang: "EN", keys: {
		"action.kess.kdm.certificate": "Import Device Certificate",
		"action.kess.kdm.issue": "Issue Key Domain Membership",
		"action.kess.kdm.createkd": "Create Key Domain",
		"action.kess.kdm.deletekd": "Delete Key Domain",
 	}}
 ]);



function IssueKeyDomainMembershipRequestController(plugin) {
	GPSystem.log(GPSystem.DEBUG, module.id, "new IssueKeyDomainMembershipRequestController()");
	BackendServiceRequestControllerBase.call(this, plugin);
}

exports.IssueKeyDomainMembershipRequestController = IssueKeyDomainMembershipRequestController;

IssueKeyDomainMembershipRequestController.prototype = Object.create(BackendServiceRequestControllerBase.prototype);
IssueKeyDomainMembershipRequestController.constructor = IssueKeyDomainMembershipRequestController;
