/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2016 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for enrolling systems
 */

var EnrollBaseRequestController = require('pki-as-a-service/processes/EnrollBaseRequestController').EnrollBaseRequestController;
var I18N = require('scsh/srv-cc1/I18N').I18N;



I18N.addResources([
	{ lang: "EN", keys: {
		"msg.enrs.title": "Enroll System"
	}}
]);



/**
 * CTOR
 *
 * Derived from EnrollBaseRequestController
 */
function EnrollSystemRequestController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new EnrollSystemRequestController()");
}

EnrollSystemRequestController.prototype = Object.create(EnrollBaseRequestController.prototype);
EnrollSystemRequestController.constructor = EnrollSystemRequestController;

exports.EnrollSystemRequestController = EnrollSystemRequestController;



/**
 * Handle POST request to create service request and initiate a GET after POST redirect to
 * the newly created service request.
 *
 * @param {HttpRequest} req the request object
 * @param {HttpResponse} res the response object
 * @param {ServiceRequestController} srct the service request controller in which this controller is embedded.
 * @param {String} action from the POST parameter
 * @type boolean
 * @return true if processing completed, false if it failed
 */
EnrollSystemRequestController.prototype.postCreateAction = function(req, res, srct, action, trustCenter) {
	var t = {
		process: "EnrollSystemServiceRequest",
		title: srct.i18n("msg.enrs.title"),
		recipientId: trustCenter.getId(),
		content: {
			type: "System"
		}
	};

	var vo = srct.createServiceRequest(t);

	srct.ui.redirectTo(req, res, req.url, "/sr/" + vo.id);
	return true;
}



/**
 * Handle GET request to show page with information about creating this service request.
 *
 * @param {HttpRequest} req the request object
 * @param {HttpResponse} res the response object
 * @param {ServiceRequestController} srct the service request controller in which this controller is embedded.
 * @type XML
 * @return The XHTML to be embedded in the service request controller frame.
 */
EnrollSystemRequestController.prototype.getCreateView = function(req, res, srct, trustCenter) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var subjectLink = srct.ui.homeURL(req.url) + "/subject/" + trustCenter.getId();

	var form =	<div>
				<h1>Enroll System</h1>
				<p>This service request enrolls a new system managed by the registration role for trust center <a href={subjectLink}>{trustCenter.getName()}</a></p>
				<p>The new enrolled system can be assigned a token and optionally a certificate
				can be issued by one of the X509 signers operated by this trust center.</p>

				<form class="pure-form" action="" method="post" enctype="multipart/form-data">
					<button class="pure-button" type="submit" name="action" value="create">Start Request</button>
				</form>
			</div>

	return form;
}
