/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2023 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for creating a new Group Signer
 */

var BackendServiceRequestControllerBase = require('pki-as-a-service/ui/BackendServiceRequestControllerBase').BackendServiceRequestControllerBase;
var I18N = require('scsh/srv-cc1/I18N').I18N;


I18N.addResources([
 	{ lang: "EN", keys: {
		"action.kess.enumeratekeydomains": "Enumerate Key Domains",
		"msg.kess.groupSigner": "Group Signer",
        "msg.kess.group": "Group",
        "msg.kess.groupName": "Group Name",
        "msg.kess.groupName.tooltip": "An up to 11-character unique group name encoded as CHR in the group signer CV-Certificate",
        "msg.kess.groupLabel": "Group Label",
        "msg.kess.groupLabel.tooltip": "A human readable descriptive label for the group",
        "msg.kess.escrowName": "Escrow Name",
        "msg.kess.escrowName.tooltip": "An up to 11-character unique escrow name encoded as CHR in the escrow key CV-Certificate",
		"msg.kess.holderName": "Name",
		"msg.kess.keyDomain": "Key Domain",

		"action.signer.create": "Create Signer",
 	}}
 ]);





function CreateGroupRequestController(plugin) {
	GPSystem.log(GPSystem.DEBUG, module.id, "new CreateGroupRequestController()");
	BackendServiceRequestControllerBase.call(this, plugin);
}

exports.CreateGroupRequestController = CreateGroupRequestController;

CreateGroupRequestController.prototype = Object.create(BackendServiceRequestControllerBase.prototype);



CreateGroupRequestController.prototype.postCreateAction = function(req, res, srct, action, subject) {
	var data = { process: "CreateGroup",
		originatorId: srct.ui.session.user.id,
		recipientId: subject.getId() };

	return BackendServiceRequestControllerBase.prototype.postCreateActionViaAPI.call(this, req, res, srct, data);
}



CreateGroupRequestController.prototype.getCreateView = function(req, res, srct, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var view =	<div>
				<h1>Create Group</h1>

				<p>A group of tokens, assigned to subjects, that can share keys in a key domain, controlled by a group signer.</p>

				<p>This service request creates a group signer that can be used to issue key domain memberships. A key
				   domain membership is an electronically signed document that entitles a certain SmartCard-HSM to
				   be part of a key domain.</p>

				<p>The group signer private key is created on a SmartCard-HSM token connected to one of the backend services.
				   Subsequently you are requested to select the token and key domain in which the signer should be created.</p>

				<form class="pure-form" action="" method="post" enctype="multipart/form-data">
					<button class="pure-button" type="submit" name="action" value="create">Start Request</button>
				</form>
			</div>

	return view;
}
