/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2025 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview KeyEscrowHolderView
 */

var HolderView		= require('pki-as-a-service/ui/HolderView').HolderView;

function KeyEscrowHolderView(service, holder) {
    this.service = service;
    this.holder = holder;
	GPSystem.log(GPSystem.DEBUG, module.id, "new KeyEscrowHolderView()");
}

KeyEscrowHolderView.prototype = Object.create(HolderView.prototype);
KeyEscrowHolderView.constructor = KeyEscrowHolderView;

exports.KeyEscrowHolderView = KeyEscrowHolderView;



KeyEscrowHolderView.prototype.getDetails = function(homeURL, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var details = <details id="holderview"></details>;
	details.appendChild(this.getSummary(homeURL, subjectController, subject));

    this.enumerateSigner();
    for (var i = 0; i < this.signerList.length; i++) {
        var signer = this.signerList[i];
        details.appendChild(this.renderKeysInEscrow(signer));
    }

	return details;
}



KeyEscrowHolderView.prototype.getSummary = function(homeURL, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var holderDAO = this.service.daof.getHolderDAO();
    var content = this.holder.getContent();
	var gsHolder = holderDAO.getHolderById(content.groupSignerHolderId);

	var summary = <summary class="paas-holder-view-summary">
		<h3 class="paas-holder-view-heading" id={this.holder.id}>{ this.holder.type } { this.holder.name } ({ gsHolder.name })</h3>
		<div id="holdermenu" class= "paas-holder-view-li paas-holder-view-holder-menu">
		</div>
	</summary>

	return summary;
}



KeyEscrowHolderView.prototype.enumerateSigner = function() {
    if (!this.signerList) {
        var certDAO = this.service.daof.getCertificateDAO();
        var certs = certDAO.enumerateCertificates(this.holder);
        var signerDAO = this.service.daof.getSignerDAO();
        this.signerList = [];
        for (var i = 0; i < certs.length; i++) {
            var signer = signerDAO.getSignerByKeyId(this.holder, certs[i].keyId);
            this.signerList.push(signer);
        }
    }

	return this.signerList;
}



KeyEscrowHolderView.prototype.renderKeysInEscrow = function(signer) {
    default xml namespace = "http://www.w3.org/1999/xhtml";

    var kdInfo = signer.keyDomain.toString(HEX);
    if (kdInfo.length > 16) {
        kdInfo = kdInfo.substring(0, 16) + "...";
    }

    var keyEscrowDAO = this.service.daof.getKeyEscrowDAO();
    var keys = keyEscrowDAO.getKeyEscrowBySigner(signer.id);

    if (keys.length == 0) {
        return <div>
            <p>No keys in escrow for key <b>{signer.name}</b> of Key Domain <b>{kdInfo}</b>.</p>
        </div>
    }

    var div = <div>
        <p>Escrow key <b>{signer.name}</b> of Key Domain <b>{kdInfo}</b> holds the following keys in escrow:</p>
    </div>

    var t = <table class="pure-table pure-table-horizontal"/>;
	t.thead += <thead>
		<tr>
			<th>Label</th>
			<th>Key ID</th>
		</tr>
	</thead>;
	t.tbody += <tbody/>;

    for (var i = 0; i < keys.length; i++) {
        var key = keys[i];
        var tr = <tr>
			<td>{ key.name }</td>
			<td>{ key.keyId.toString(HEX) }</td>
		</tr>;

		t.tbody.appendChild(tr);
    }

    div.appendChild(t);

    return div;
}
