/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2025 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview GroupSignerHolderView
 */

var CVCHolderView		= require('pki-as-a-service/ui/CVCHolderView').CVCHolderView;
var CVC = require('scsh/eac/CVC').CVC;



function GroupSignerHolderView(service, holder) {
    this.service = service;
    this.holder = holder;
	GPSystem.log(GPSystem.DEBUG, module.id, "new GroupSignerHolderView()");
}

GroupSignerHolderView.prototype = Object.create(CVCHolderView.prototype);
GroupSignerHolderView.constructor = GroupSignerHolderView;

exports.GroupSignerHolderView = GroupSignerHolderView;



GroupSignerHolderView.prototype.renderCertificateTable = function(homeURL) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var certs = this.getCertificates();
	if (certs.length == 0) {
		return <p>No Signer was created for this holder.</p>
	}
	var t = <table class="pure-table pure-table-horizontal"/>;
	t.thead += <thead>
		<tr>
			<th>CHR</th>
			<th>Key Domain UID</th>
			<th>In Key Domain</th>
			<th>Configuration</th>
		</tr>
	</thead>;
	t.tbody += <tbody/>;

	for (var i = 0; i < certs.length; i++) {
		var cert = certs[i];

		var cvc = new CVC(cert.bytes);

		var signer = this.getSigner(cert);

		var kdInfo = "No Signer";
		var configId;
		var configName;

		if (signer) {
			kdInfo = signer.keyDomain.toString(HEX);
			if (kdInfo.length > 16) {
				kdInfo = kdInfo.substring(0, 16) + "...";
			}
			var content = signer.getContent();
			if (typeof(content.configId) != "undefined") {
				configId = content.configId;
				configName = content.configName;
			}
		}

		var kduid = cvc.getECPublicKeyIdentifier();
        var forKdInfo = kduid.left(8).toString(HEX) + "...";

		var mark = cert.id == this.holder.certId ? "*" : "";

		var url = homeURL + "/cert/" + cert.id;
		var tr = <tr>
			<td><a href={ url }>{ cvc.getCHR() }</a>{ mark }</td>
			<td>{ forKdInfo }</td>
			<td>{ kdInfo }</td>
		</tr>;

		if (configId) {
				var url = homeURL + "/sr/" + configId;
				tr.appendChild(<td><a href={ url }>{ configName }</a></td>);
		} else {
				tr.appendChild(<td/>);
		}

		t.tbody.appendChild(tr);
	}

	return t;
}
