/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2023 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for adding a subject with token to an existing group
 */

var I18N = require('scsh/srv-cc1/I18N').I18N;
var BackendServiceRequestControllerBase = require('pki-as-a-service/ui/BackendServiceRequestControllerBase').BackendServiceRequestControllerBase;



I18N.addResources([
 	{ lang: "EN", keys: {
		"msg.kess.join": "Join Group Data",
 	}}
 ]);



function JoinGroupRequestController(plugin) {
	GPSystem.log(GPSystem.DEBUG, module.id, "new JoinGroupRequestController()");
	BackendServiceRequestControllerBase.call(this, plugin);
}

exports.JoinGroupRequestController = JoinGroupRequestController;

JoinGroupRequestController.prototype = Object.create(BackendServiceRequestControllerBase.prototype);



JoinGroupRequestController.prototype.postCreateAction = function(req, res, srct, action, subject) {
	var data = { process: "JoinGroup",
		originatorId: srct.ui.session.user.id,
		recipientId: subject.getId() };

	return BackendServiceRequestControllerBase.prototype.postCreateActionViaAPI.call(this, req, res, srct, data);
}



JoinGroupRequestController.prototype.getCreateView = function(req, res, srct, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var view =	<div>
				<h1>Join Group</h1>

				<p>Make the subject part of a group by joining a key domain with one of the
				   assigned tokens.</p>

				<p>While this service requests does establish the relationship between a
				   certain token of the subject with the group, the actuals issuing of
				   the key domain membership is done in a related service request, that
				   is automatically created.</p>

				<form class="pure-form" action="" method="post" enctype="multipart/form-data">
					<button class="pure-button" type="submit" name="action" value="create">Start Request</button>
				</form>
			</div>

	return view;
}
