/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2021 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Base model for CA subjects
 */

var SubjectModel = require('pki-as-a-service/service/SubjectModel').SubjectModel;



/**
 * Data model for CA Subjects
 *
 *
 * @constructor
 */
function CASubject(service, bo) {
	SubjectModel.call(this, service, bo);
}

CASubject.prototype = Object.create(SubjectModel.prototype);
CASubject.constructor = CASubject;

exports.CASubject = CASubject;



CASubject.prototype.getRARoleId = function() {
	var camodel = this.bo.getContent();
	return camodel.raRoleId;
}



CASubject.prototype.isRegistrationOfficer = function(user) {
	return (typeof(user.roles) != "undefined") && (user.roles.indexOf(this.getRARoleId()) >= 0);
}



CASubject.prototype.getCARoleId = function() {
	var camodel = this.bo.getContent();
	return camodel.caRoleId;
}



CASubject.prototype.isCertificationOfficer = function(user) {
	return (typeof(user.roles) != "undefined") && (user.roles.indexOf(this.getCARoleId()) >= 0);
}



CASubject.prototype.canRead = function(user) {
	if (SubjectModel.prototype.canRead.call(this, user)) {
		return true;
	}

	if (this.isRegistrationOfficer(user)) {
		return true;
	}

	if (this.isCertificationOfficer(user)) {
		return true;
	}

	return false;
}



/**
 * Check if this CASubject is manager of the given user
 */
CASubject.prototype.isManagerOf = function(user) {
	if (this.getRARoleId() == user.managedByRoleId) {
		return true;
	}

	return false;
}



CASubject.prototype.getHSM = function(keyDomain) {
	GPSystem.log(GPSystem.DEBUG, module.id, "getHSM(" + keyDomain.toString(HEX) + ")");
	var tokenList = this.getToken();
	for (var i = 0; i < tokenList.length; i++) {
		var token = tokenList[i];
		hsm = this.service.hsmService.getHSMState(token.path);
		if (!hsm || hsm.isOffline()) {
			GPSystem.log(GPSystem.DEBUG, module.id, "Skip HSM " + hsm + " for path " + token.path);
			continue;
		}

		for (var j = 0; j < hsm.keyDomain.length; j++) {
			var kd = hsm.keyDomain[j];
			GPSystem.log(GPSystem.DEBUG, module.id, "Compare with kd " + kd.toString(HEX));
			if (kd.equals(keyDomain)) {
				var slot = j - 1; // -1 if default domain, otherwise the corresponding slot
				return {
					hsm: hsm,
					slot: slot
				};
			}
		}
	}
}
