/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2010 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview A ping service that is periodically called to handle background tasks
 */

function PingService(service, port) {
	this.service = service;
	this.port = port;
}

exports.PingService = PingService;

/**
 * Dispatch all GET inquiries
 *
 * @param {HttpRequest} req the request object
 * @param {HttpResponse} req the response object
 */
PingService.prototype.handleRequest = function(req, res) {
	if (req.localPort != this.port) {
		res.setStatus(HttpResponse.SC_UNAUTHORIZED);
		return;
	}

	var url = req.pathInfo.substr(1).split("/");
	print(url);
	if (url[1] == "sr") {
		var id = parseInt(url[2]);
		this.pingServiceRequest(req, res, id);
	}
}



PingService.prototype.pingServiceRequest = function(req, res, id) {
	print("ping " + id);
	var sr = this.service.getServiceRequestById(id);
	if (typeof(sr.ping) == "function") {
		sr.ping(req, res);
	}
}
