/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2025 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview HolderView
 */

var MenuModel = require('pki-as-a-service/ui/MenuModel').MenuModel;
var PureMenuGenerator		= require('pki-as-a-service/ui/PureMenuGenerator').PureMenuGenerator;
var CVC = require('scsh/eac/CVC').CVC;



function HolderView(service, holder) {
    this.service = service;
    this.holder = holder;
	GPSystem.log(GPSystem.DEBUG, module.id, "new HolderView()");
}

exports.HolderView = HolderView;



HolderView.prototype.getView = function(homeURL, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var div = <div class="card paas-holder-view-card"/>;

	div.appendChild(this.getDetails(homeURL, subjectController, subject));

	var processes = this.getMenuModel(homeURL, subjectController, subject);
	var gen = new PureMenuGenerator();
	var menu = gen.generateHorizontalMenu(processes, true);
	var menudiv = div..div.(@id == "holdermenu");
	menudiv.appendChild(menu);

	return div;
}



HolderView.prototype.getSummaryTemplate = function() {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var summary = <summary class="paas-holder-view-summary">
			<h3 class="paas-holder-view-heading" id={this.holder.id}></h3>
			<div id="holdermenu" class= "paas-holder-view-li paas-holder-view-holder-menu">
			</div>
		</summary>
	return summary;
}



HolderView.prototype.getSummary = function(homeURL, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var url = homeURL + "/holder/" + this.holder.id;
	var holderDAO = this.service.daof.getHolderDAO();
	var count = holderDAO.countSubHolder(this.holder.id);

	var summary = <summary class="paas-holder-view-summary">
		<h3 class="paas-holder-view-heading" id={this.holder.id}>
			{ this.holder.type } { this.holder.name } <a class="alternative" href={url}><sub>&#9492; { count }</sub></a>
		</h3>
		<div id="holdermenu" class= "paas-holder-view-li paas-holder-view-holder-menu">
		</div>
	</summary>

	return summary;
}



HolderView.prototype.getDetails = function(homeURL, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var details = <details id="holderview"></details>;
	details.appendChild(this.getSummary(homeURL, subjectController, subject));

	return details;
}



HolderView.prototype.getMenuModel = function(homeURL, subjectController, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var user = subjectController.ui.session.user;

	var model = new MenuModel();
	var sub = new MenuModel(<span class="menu-icon"></span>);
	model.addItem(sub);

	var processes = subjectController.service.pluginRegistry.enumerateRunnableProcessesForHolderType(subjectController.ui.session.user, subject, this.holder.type);

	for (var i = 0; i < processes.length; i++) {
		var p = processes[i];
		var url = homeURL + "/sr/new?process=" + p.process + "&for=" + subject.getId() + "&holder=" + this.holder.id;
			sub.addItem(<a href={url}>{ p.label }</a>);
	}

	if (sub.hasChildren) {
		return model;
	}
}
