/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2018 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Determine Key Domain
 */

var SmartCardHSM	= require('scsh/sc-hsm/SmartCardHSM').SmartCardHSM;
var CVC				= require("scsh/eac/CVC").CVC;



function KeyDomain() {

}

exports.KeyDomain = KeyDomain;



KeyDomain.KCV_PREFIX = new ByteString("0102030405060708090A0B", HEX);
KeyDomain.SOFTWARE_KEYSTORE = ByteString.valueOf(0, 20);



/**
 * DEPRECATED This function only supports one key domain
 * Determine key domain
 *
 * @param {SmartCardHSM} sc the SmartCard-HSM
 * @param {CVC} devAutCert the device authentication certificate (optional - will be read from EF.C_DevAut otherwise)
 * @type ByteString
 * @return the key domain for the given SmartCard-HSM
 */
KeyDomain.determineKeyDomain = function(sc, devAutCert) {
	var status = sc.importKeyShare();
	if (status.kcv) {
		return KeyDomain.KCV_PREFIX.concat(status.kcv);
	}

	if(!devAutCert) {
		var cbin = sc.readBinary(SmartCardHSM.C_DevAut);
		var devAutCert = new CVC(cbin);
	}

	return devAutCert.determineKeyIdentifier();
}



KeyDomain.getDefaultKeyDomainFromCert = function(devAutCert) {
	var pub = devAutCert.getPublicKey();
	var defaultId = pub.getComponent(Key.ECC_QX);
	return defaultId;
}



KeyDomain.getKeyDomains = function(sc, devAutCert) {
	GPSystem.log(GPSystem.DEBUG, module.id, "getKeyDomains");
	var defaultId = KeyDomain.getDefaultKeyDomainFromCert(devAutCert);

	var list = [defaultId]; // default domain

	var kdid = 0;
	do	{
		var status = sc.queryKeyDomainStatus(kdid++);

		if ((status.sw == 0x6D00) || // No key domains configured during initialization
			(status.sw == 0x6A86) // kdid exceeds the number of key domains
		) {
			break;
		}

		if (status.outstanding > 0) {
			continue;
		}

		if (status.sw == 0x9000) { // key domain have been initialized
			if (status.keyDomain) { // XKEK UID
				list.push(status.keyDomain);
			} else { // DKEK
				list.push(status.kcv);
			}
		}
	} while ((status.sw == 0x9000) || (status.sw == 0x6A88));

	return list;
}
