/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2023 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Adapter to render service requests from microservices
 */

var ServiceRequestModel		= require('pki-as-a-service/service/ServiceRequestModel').ServiceRequestModel;



function ServiceRequestAdapter(service, bo, plugin) {
	ServiceRequestModel.call(this, service, bo);
    this.plugin = plugin;
}

ServiceRequestAdapter.prototype = Object.create(ServiceRequestModel.prototype);
ServiceRequestAdapter.constructor = ServiceRequestAdapter;

exports.ServiceRequestAdapter = ServiceRequestAdapter;



ServiceRequestAdapter.prototype.setServiceResponse = function(sr) {
    this.sr = sr;
}



ServiceRequestAdapter.prototype.getServiceResponse = function(user) {

	var api = this.plugin.getAPI();
	try	{
        this.sr = api.getServiceRequest(this.getId(), user.id, true);
	}
	catch(e) {
		GPSystem.log(GPSystem.ERROR, module.id, "Connection to backend failed with : " + e.message);
	}
}



ServiceRequestAdapter.prototype.getForm = function(user) {
    if (typeof(this.sr) == "undefined") {
        this.getServiceResponse(user);
    }

    if (typeof(this.sr) == "undefined") {
        return [];
    }

    return this.sr.form;
}



ServiceRequestAdapter.prototype.getActionList = function() {
    if ((typeof(this.sr) == "undefined") || (typeof(this.sr.actions) == "undefined")) {
        return [];
    }

    return this.sr.actions;
}
