/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2016 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for RegisterMyTokenRequestModel
 */

RegisterMyTokenRequestModel = require('pki-as-a-service/processes/RegisterMyTokenRequestModel').RegisterMyTokenRequestModel;
I18N = require('scsh/srv-cc1/I18N').I18N;



I18N.addResources([
	{ lang: "EN", keys: {
		"msg.registration.title": "Register Token",
		"msg.registration.data": "Registration Information",
		"msg.registration.token": "Token",
		"msg.registration.email": "e-Mail",
		"msg.registration.newemail": "New e-Mail",
		"msg.registration.activationTries": "Tries left",

		"msg.registration.notifications": "Notification Settings",

		"action.registration.change_email": "Change E-mail",
		"action.registration.change_email.tooltip": "Disconnect token, cancel pending registration and send fresh activation code",
		"action.registration.unblock_activation_code": "Unblock Activation Code",
		"action.registration.unblock_activation_requests": "Unblock Activation Code Requests",
		"action.registration.reject": "Reject Registration",
		"action.registration.terminate": "Deregister Token"
	}}
//	,
//	{ lang: "DE", keys: {
//		"action.save": "Speichern"
//	}}
]);



function RegisterMyTokenRequestController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new RegisterMyTokenRequestController()");
}

exports.RegisterMyTokenRequestController = RegisterMyTokenRequestController;



/**
 * This controller does not create a RegisterMyTokenServiceRequest.
 * Such service request will be created by the service.
 */
RegisterMyTokenRequestController.prototype.postCreateAction = function(req, res, srct, action) {
	GPSystem.log(GPSystem.WARN, module.id, "postCreateAction not implemented");
	return false;
}



RegisterMyTokenRequestController.prototype.postProcessAction = function(req, res, srct, sr, action) {
	GPSystem.log(GPSystem.DEBUG, module.id, "postProcessAction: " + action);

	switch(action) {
		case "action.registration.change_email":
		case "action.save":
		if (!sr.setFields(srct.ui.session.user, req.parameters)) {
			var page = srct.getProcessView(req, res, sr);
			srct.ui.sendPage(req, res, req.url, page);
			return true;
		}
		break;
	}
	sr.perform(srct.ui.session.user, action);
	return false;
}



/**
 * No Create View necessary.
 */
RegisterMyTokenRequestController.prototype.getCreateView = function(req, res, srct) {
	default xml namespace = "http://www.w3.org/1999/xhtml";
	GPSystem.log(GPSystem.WARN, module.id, "getCreateView not implemented");
	var form =	<div></div>
	return form;
}



RegisterMyTokenRequestController.prototype.getProcessView = function(req, res, srct, sr) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var div = <div />;

	div.appendChild(srct.renderForm(req, res, sr));

	return div;
}



RegisterMyTokenRequestController.prototype.createRequest = function(service, parameter) {
	var srDAO = service.daof.getServiceRequestDAO();

	var split = parameter.token.path.split("/");
	var info = split[split.length - 1];

	var t = {
		process: "RegisterMyTokenServiceRequest",
		title: I18N.t(parameter.lang, "msg.registration.title"),
		details: info,
		state: "Created",
		content: {
			tokenId: parameter.token.path,
			activationRequests: RegisterMyTokenRequestModel.NO_OF_INITIAL_ACTIVATION_REQUESTS,
			activationTries: RegisterMyTokenRequestModel.INITIAL_ACTIVATION_TRIES
		}
	};

	if (parameter.enrollmentServiceRequestId) {
		t.parentServiceRequestId = parameter.enrollmentServiceRequestId;
	}

	if (parameter.originatorId) {
		t.originatorId = parameter.originatorId;
	}

	if (parameter.raRoleID) {
		t.content.raRoleID = parameter.raRoleID;
	}

	if (parameter.subjectId) {
		t.content.subjectId = parameter.subjectId;
	}

	var bo = srDAO.newServiceRequest(t);

	if (parameter.email) {
		var sr = service.getServiceRequestById(bo.id);
		sr.setEmail(parameter.email);
	}

	var tokenDAO = service.daof.getTokenDAO();
	tokenDAO.addTokenAction(parameter.token.id, bo.id);

	return bo;
}
