/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2018 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for ManageRoleServiceRequest
 */

var Person = require('pki-as-a-service/subjects/Person').Person;
var CommonUI = require('scsh/srv-cc1/CommonUI').CommonUI;
var I18N = require('scsh/srv-cc1/I18N').I18N;



I18N.addResources([
	{ lang: "EN", keys: {
		"msg.mr.title": "Manage Role",
		"msg.mr.assign": "Assign Role to Subject",
		"msg.mr.remove": "Remove Role from Subject",
		"msg.mr.select": "Select Roles",
		"msg.mr.assigned": "Assigned Roles",
		"msg.mr.removed": "Removed Roles",
		"msg.mr.subject": "Subject",
		"msg.mr.id": "ID",
		"msg.mr.roles": "Roles",
		"msg.mr.noAssignableRoles": "No assignable role",
		"msg.mr.noRemovableRoles": "No removable role",
	}}
]);



function ManageRoleServiceRequestController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new ManageRoleServiceRequestController()");
}

exports.ManageRoleServiceRequestController = ManageRoleServiceRequestController;



ManageRoleServiceRequestController.prototype.createRequest = function(srct, subject) {

	var srDAO = srct.service.daof.getServiceRequestDAO();

	if (subject.bo.name) {
		var details = subject.bo.name;
	} else {
		var details = subject.bo.email;
	}

	var t = {
		process: "ManageRoleServiceRequest",
		title: srct.i18n("msg.mr.title"),
		details: details,
		originatorId: srct.ui.session.user.id,
		recipientId: subject.getId(),
		state: "Created",
		content: "{}"
	};

	var bo = srDAO.newServiceRequest(t);
	return bo;
}



ManageRoleServiceRequestController.prototype.postCreateAction = function(req, res, srct, action, subject) {
	if (!subject.canRead(srct.ui.session.user)) {
	  return false;
	} else if (!(subject instanceof Person)) {
		return false;
	}

	var bo = this.createRequest(srct, subject);

	srct.ui.redirectTo(req, res, req.url, "/sr/" + bo.id);
	return true;
}



ManageRoleServiceRequestController.prototype.postProcessAction = function(req, res, srct, sr, action) {

	switch(action) {
	case "action.save":
	case "action.update":
		if (!sr.setFields(srct.ui.session.user, req.parameters)) {
			var page = srct.getProcessView(req, res, sr);
			srct.ui.sendPage(req, res, req.url, page);
			return true;
		}
		break;
	}

	sr.perform(srct.ui.session.user, action);

	return false;
}



ManageRoleServiceRequestController.prototype.getCreateView = function(req, res, srct, subject) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var subjectLink = srct.ui.homeURL(req.url) + "/subject/" + subject.getId();
	var nameOrEmail = subject.bo.name ? subject.bo.name : subject.bo.email;

	var form =	<div>
				<h1>Manage Roles</h1>
				<p>This service requests manages the roles of subject <a href={subjectLink}>{nameOrEmail}</a>. You can assign new roles and/or remove previously assigned roles if you are authorized to manage the specific role.</p>

				<form class="pure-form" action="" method="post" enctype="multipart/form-data">
					<button class="pure-button" type="submit" name="action" value="create">Start Request</button>
				</form>
			</div>

	return form;
}



ManageRoleServiceRequestController.prototype.getProcessView = function(req, res, srct, sr) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var div = <div />;

	div.appendChild(srct.renderForm(req, res, sr));

	return div;
}
