/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2017 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview HTML menu generator using Pure.CSS
 */



MenuModel = require('pki-as-a-service/ui/MenuModel').MenuModel;



function PureMenuGenerator() {

}

exports.PureMenuGenerator = PureMenuGenerator;



PureMenuGenerator.prototype.generateHorizontalMenu = function(model) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var menu = <div class="pure-menu pure-menu-horizontal"/>
	menu.appendChild(this.generateMenuList(model));

	return menu;
}



PureMenuGenerator.prototype.generateVerticalMenu = function(model) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	/* limit menu width via
	 * display: inline-block;
	 * or set width explicitly
	 */
	var menu = <div class="pure-menu" style="display: inline-block;"/>
	menu.appendChild(this.generateMenuList(model));

	return menu;
}



PureMenuGenerator.prototype.generateMenuList = function(model, isChild) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var menu = <ul/>;
	if (isChild) {
		menu.@class = "pure-menu-children";
	} else {
		menu.@class = "pure-menu-list";
	}

	for (var i = 0; i < model.getChildren().length; i++) {
		var child = model.getChildren()[i];
		var item = child.getItem();

		if (child.status == MenuModel.STATE_PRE_RENDERED) {
			menu.appendChild(item);
			continue;
		}

		item.@class += " pure-menu-link";

		var li = <li class="pure-menu-item">{item}</li>;
		if (child.status == MenuModel.STATE_SELECTED) {
			li.@class += " pure-menu-selected";
		} else if (child.status == MenuModel.STATE_DISABLED) {
			li.@class += " pure-menu-disabled";
		}

		if (child.hasChildren()) {
			li.@class += " pure-menu-has-children pure-menu-allow-hover";
			li.appendChild(this.generateMenuList(child, true));
		}

		menu.appendChild(li);
	}

	return menu;
}



function test() {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var menu = new MenuModel("ROOT");

	var home = new MenuModel(<a href="../../paas">Home</a>);
	/*
	 * home.addItem( { name: "Create Root-CA", url: "http://", icon: "File", enabled: true };
	 */
	home.addItem(<a href="../../paas/sr/new?process=CreateRootCAServiceRequest">Create Root-CA</a>);
	home.addItem(<a href="../../paas/sr/new?process=CertificateServiceRequest">Request Certificate</a>);
	home.addItem(<a href="../../paas?op=sign">Sign some Data</a>);

	var views = new MenuModel(<p class="no-margin">Views</p>);
	views.addItem(<a href="../../paas/subject">Subjects</a>);
	views.addItem(<a href="/se/hsm">SmartCard-HSM</a>);

	var ca = new MenuModel(<p class="no-margin">CA</p>);
	ca.addItem(<a href="../../paas/sr/new?process=EnrollPersonServiceRequest&amp;ca=2">Enroll Person</a>);
	ca.addItem(<a href="../../paas/sr/new?process=EnrollSystemServiceRequest&amp;ca=2">Enroll System</a>);

	menu.addItem(home);
	menu.addItem(views);
	menu.addItem(ca);

	var gen = new PureMenuGenerator();
	var html = gen.generateHorizontalMenu(menu);
	print(html.toXMLString());
}