/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 2016 CardContact Systems GmbH
 * |'##> <##'|  Schuelerweg 38, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Factory for core subject types
 */

var TrustCenter			= require('pki-as-a-service/subjects/TrustCenter').TrustCenter;
var TrustCenterController	= require('pki-as-a-service/subjects/TrustCenterController').TrustCenterController;
var Person			= require('pki-as-a-service/subjects/Person').Person;
var System			= require('pki-as-a-service/subjects/System').System;
var BaseSubjectController	= require('pki-as-a-service/subjects/BaseSubjectController').BaseSubjectController;



function CoreSubjects(service) {
	this.service = service;
	this.priority = 500;
}

exports.Plugin = CoreSubjects;



CoreSubjects.prototype.getFactoryForSubject = function(type) {
	GPSystem.log(GPSystem.DEBUG, module.id, "getFactoryForSubject(" + type + ")");

	switch(type) {
		case "X509RootCA":
		case "TrustCenter":
		case "System":
		case "Person":
			return this;
			break;
	}
	return undefined;
}



CoreSubjects.prototype.getSubject = function(bo) {
	GPSystem.log(GPSystem.DEBUG, module.id, "getSubject(" + bo + ")");
	switch (bo.type) {
		case "X509RootCA":
		case "TrustCenter":
			var subject = new TrustCenter(this.service, bo);
			break;
		case "System":
			var subject = new System(this.service, bo);
			break;
		case "Person":
			var subject = new Person(this.service, bo);
			break;
		default:
			throw new GPError(module.id, GPError.INVALID_DATA, 0, "Type " + bo.type + " not supported by this factory");
	}
	return subject;
}



CoreSubjects.prototype.getControllerForSubject = function(type) {
	GPSystem.log(GPSystem.DEBUG, module.id, "getControllerForSubject(" + type + ")");
	switch(type) {
		case "X509RootCA":
		case "TrustCenter":
			return new TrustCenterController();
		case "Person":
		case "System":
			return new BaseSubjectController();
	}
	return undefined;
}



CoreSubjects.prototype.toString = function() {
	return "Core Subjects";
}
