/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2016 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for CertificateServiceRequest
 */

InitializationWizard = require('pki-as-a-service/ui/InitializationWizard').InitializationWizard;
CardActionWizard = require('pki-as-a-service/ui/CardActionWizard').CardActionWizard;
ServiceRequestModel = require('pki-as-a-service/service/ServiceRequestModel').ServiceRequestModel;
SubjectDAO = require('scsh/pki-db/db/SubjectDAO').SubjectDAO;
CommonUI = require('scsh/srv-cc1/CommonUI').CommonUI;
I18N = require('scsh/srv-cc1/I18N').I18N;

TrustCenter			= require('pki-as-a-service/subjects/TrustCenter').TrustCenter;


I18N.addResources([
	{ lang: "EN", keys: {
		"msg.it.title": "Issue Token",
		"msg.er.subject": "Subject",
		"msg.er.token": "Token",
		"msg.er.id": "ID",
		"msg.er.status": "Status",
		"msg.er.name": "Name",
		"msg.er.email": "Email",
		"msg.er.register": "Registration Service Request",
		"msg.er.requestCert": "Certificate Service Request",
		"msg.er.issuer": "Issuer",
		"msg.er.ca": "CA",

		"msg.it.init": "Token Configuration",
		"msg.it.derivationKeyLabel": "SO-PIN Derivation Key",
		"msg.it.rrcMode": "Resetting PIN with SO-PIN allowed",
		"msg.it.transportMode": "Transport PIN enabled",
		"msg.it.pin": "PIN",
		"msg.it.noOfKeyDomains": "Number of Key Domains",

		"action.save": "Save",
		"action.selectToken": "Select Token",
		"action.registerToken": "Register Token",
		"action.deregisterToken": "Deregister Token",
		"action.initialize": "Initialize Token",
		"action.reqCert": "Request Certificate"
	}}
//	,
//	{ lang: "DE", keys: {
//		"action.save": "Speichern"
//	}}
]);



function IssueTokenRequestController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new IssueTokenRequestController()");
}

exports.IssueTokenRequestController = IssueTokenRequestController;



// IssueTokenRequestController.prototype.getTrustCenter = function(req, res, srct) {
// 	var parameter = CommonUI.parseQueryString(req.queryString);
// 	var id = Number(parameter.trustcenter);
//
// 	if (isNaN(id) || id == 0) {
// 		throw new GPError(module.id, GPError.INVALID_DATA, 0, "Argument id not valid in URL");
// 	}
//
// 	var subject = srct.service.getSubject(id);
//
// 	return subject;
// }



IssueTokenRequestController.prototype.getSubject = function(req, res, srct) {
	var parameter = CommonUI.parseQueryString(req.queryString);
	var id = Number(parameter.subject);

	if (isNaN(id) || id == 0) {
		throw new GPError(module.id, GPError.INVALID_DATA, 0, "Argument id not valid in URL");
	}

	var subject = srct.service.getSubject(id);

	return subject;
}



IssueTokenRequestController.prototype.createRequest = function(srct, trustCenter, subject) {

	var srDAO = srct.service.daof.getServiceRequestDAO();

	var nameOrEmail = subject.bo.name ? subject.bo.name : subject.bo.email;
	var t = {
		process: "IssueTokenServiceRequest",
		title: srct.i18n("msg.it.title"),
		details: nameOrEmail,
		originatorId: srct.ui.session.user.id,
		recipientId: trustCenter.getId(),
		state: "Created",
		lifecycle: ServiceRequestModel.LIFECYCLE_EDIT,
		content: {
			subjectId: subject.getId()
		}
	};

	var bo = srDAO.newServiceRequest(t);
	return bo;
}



IssueTokenRequestController.prototype.postCreateAction = function(req, res, srct, action) {
	var subject = this.getSubject(req, res, srct);

	// TODO Are subject permissions necessary?
	if (!subject.isOwner(srct.ui.session.user) &&
		!subject.isManager(srct.ui.session.user)) {
		return false;
	}

	var trustCenter = subject.getTrustCenter();
	if (!trustCenter.canEnroll(srct.ui.session.user)) {
		return false;
	}

	var bo = this.createRequest(srct, trustCenter, subject);

	srct.ui.redirectTo(req, res, req.url, "/sr/" + bo.id);
	return true;
}



IssueTokenRequestController.prototype.postProcessAction = function(req, res, srct, sr, action) {
	GPSystem.log(GPSystem.DEBUG, module.id, "handleAction: " + action);

	switch(action) {
	case "action.create":
	case "action.save":
		if (!sr.setFields(srct.ui.session.user, req.parameters)) {
			var page = srct.getProcessView(req, res, sr);
			srct.ui.sendPage(req, res, req.url, page);
			return true;
		}
		break;
	case "action.registerToken":
		break;
	case "action.deregisterToken":
		break;
	case "action.initialize":
		srct.ui.wizard = new InitializationWizard(srct.ui, sr, "/" + req.url[1] + "/" + req.url[2]);
		srct.ui.wizard.requestPIN = -1;
		srct.ui.redirectTo(req, res, req.url, "/wizard");
		return true;
	case "action.selectToken":
		srct.ui.wizard = new CardActionWizard(srct.ui, sr, "/" + req.url[1] + "/" + req.url[2]);
		srct.ui.wizard.requestPIN = -1;
		srct.ui.redirectTo(req, res, req.url, "/wizard");
		return true;
	}

	sr.perform(srct.ui.session.user, action);

	return false;
}



IssueTokenRequestController.prototype.getCreateView = function(req, res, srct) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var subject = this.getSubject(req, res, srct);

	var subjectLink = srct.ui.homeURL(req.url) + "/subject/" + subject.getId();

	var form =	<div>
				<h1>Issue Token</h1>
			</div>

	var trustCenter = subject.getTrustCenter();
	GPSystem.log(GPSystem.DEBUG, module.id, "is trustCenter subject? " + (trustCenter instanceof TrustCenter));
	var nameOrEmail = subject.bo.name ? subject.bo.name : subject.bo.email;
	if (trustCenter.canEnroll(srct.ui.session.user)) {
		form.appendChild(
			<p>This service request issues a token for subject <a href={subjectLink}>{nameOrEmail}</a></p>
		);

		form.appendChild(
			<form class="pure-form" action="" method="post" enctype="multipart/form-data">
				<button class="pure-button" type="submit" name="action" value="create">Start Request</button>
			</form>
		);
	} else {
		form.appendChild(
			<p>You are currently not authorized to issue a token for subject <a href={subjectLink}>{nameOrEmail}</a></p>
		)
	}

	return form;
}



IssueTokenRequestController.prototype.getProcessView = function(req, res, srct, sr) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var div = <div />;

	div.appendChild(srct.renderForm(req, res, sr));

	return div;
}
