/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2010 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Manage user authorization
 */



function AuthorizationManager(service) {
	this.service = service;
}

exports.AuthorizationManager = AuthorizationManager;



AuthorizationManager.prototype.getUser = function(id) {
	GPSystem.log(GPSystem.DEBUG, module.id, "getUser(" + id + ")");

	var tokenDAO = this.service.daof.getTokenDAO();
	var token = tokenDAO.getToken(id);
	if (token == null) {
		token = tokenDAO.newToken(id);
	}

	var user = { name: "", pinRequired: true };
	var subject;

	if (token.subjectId) {
		var subjectDAO = this.service.daof.getSubjectDAO();
		subject = subjectDAO.getSubject(token.subjectId);
	}

	if (subject && (subject.type == "Person")) {
		if (subject.name) {
			user.name = subject.name;
		} else {
			user.name = subject.email;
		}
		user.id = subject.id;
		user.tokenId = token.id;
		user.tokenPath = token.path;
		user.lang = "EN";
		if (subject.managedByRoleId) {
			user.managedByRoleId = subject.managedByRoleId;
		}

		var roleDAO = this.service.daof.getRoleDAO();
		user.roles = roleDAO.getAssignedRoleIds(user.id);
	}

	return user;
}



AuthorizationManager.prototype.loginAllowed = function(user) {
	return true;
}
