/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2020 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for RegisterDeviceIssuerServiceRequest
 */

ServiceRequestModel = require('pki-as-a-service/service/ServiceRequestModel').ServiceRequestModel;
CardActionWizard = require('pki-as-a-service/ui/CardActionWizard').CardActionWizard;
SubjectDAO = require('scsh/pki-db/db/SubjectDAO').SubjectDAO;
RoleDAO = require('scsh/pki-db/db/RoleDAO').RoleDAO;
CommonUI = require('scsh/srv-cc1/CommonUI').CommonUI;
I18N = require('scsh/srv-cc1/I18N').I18N;



I18N.addResources([
	{ lang: "EN", keys: {
		"msg.casubject.title": "Create CA Subject",

		"msg.casubject.subjectData": "Certification Authority Data",
		"msg.casubject.name": "CA Unique Name",
		"msg.casubject.token": "Assigned Token",
		"msg.casubject.lc": "Operation Mode",

		"action.cas.addToken": "Add Token",
		"action.cas.removeToken": "Remove Token",
	}}
//	,
//	{ lang: "DE", keys: {
//		"action.save": "Speichern"
//	}}
]);



function CreateTrustCenterRequestController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new CreateTrustCenterRequestController()");
}

exports.CreateTrustCenterRequestController = CreateTrustCenterRequestController;



CreateTrustCenterRequestController.prototype.createRequest = function(srct, parameter) {

	var srDAO = srct.service.daof.getServiceRequestDAO();

	var t = {
		process: "CreateTrustCenterServiceRequest",
		title: srct.i18n("msg.casubject.title"),
		originatorId: srct.ui.session.user.id,
		state: "Created",
		content: {
		}
	};

	var bo = srDAO.newServiceRequest(t);
	return bo;
}



CreateTrustCenterRequestController.prototype.postCreateAction = function(req, res, srct, action) {
	if (srct.ui.session.user.roles.indexOf(RoleDAO.ID_Subscriber) >= 0) {
		var parameter = CommonUI.parseQueryString(req.queryString);
		var bo = this.createRequest(srct, parameter);

		srct.ui.redirectTo(req, res, req.url, "/sr/" + bo.id);
		return true;
	}

	return false;
}



CreateTrustCenterRequestController.prototype.restfulPostProcessAction = function(req, res, srct, sr, action) {
	GPSystem.log(GPSystem.DEBUG, module.id, "restfulPostProcessAction: " + action);
	var s = req.getEntityAsString();
	if (s) {
		try	{
			var reqo = JSON.parse(s);
		}
		catch(e) {
			GPSystem.log(GPSystem.ERROR, module.id, "Error parsing JSON request: " + e);
			res.setStatus(HttpResponse.SC_BAD_REQUEST);
			return;
		}
	} else {
		var reqo = [];
	}
	GPSystem.log(GPSystem.DEBUG, module.id, "getEntityAsString: " +s);

	switch(action) {
	case "action.submit":
	case "action.save":
	case "action.cas.removeToken":
		if (!sr.setFields(srct.ui.session.user, reqo)) {
			GPSystem.log(GPSystem.DEBUG, module.id, "Error setting fields for reqo: " + reqo);
			// TODO return json with invalid fields
			return true;
		}
		break;
	case "action.cas.addToken":
	case "action.ca.genroot.usertoken":
		srct.ui.wizard = new CardActionWizard(srct.ui, sr, "/" + req.url[1] + "/" + req.url[2]);
		srct.ui.wizard.requestPIN = -1;
		return true;
	}

	sr.perform(srct.ui.session.user, action);

	return false;
}

CreateTrustCenterRequestController.prototype.postProcessAction = function(req, res, srct, sr, action) {
	print("handleAction: " + action);

	switch(action) {
	case "action.submit":
	case "action.save":
	case "action.cas.removeToken":
		if (!sr.setFields(srct.ui.session.user, req.parameters)) {
			var page = srct.getProcessView(req, res, sr);
			srct.ui.sendPage(req, res, req.url, page);
			return true;
		}
		break;
	case "action.cas.addToken":
	case "action.ca.genroot.usertoken":
		srct.ui.wizard = new CardActionWizard(srct.ui, sr, "/" + req.url[1] + "/" + req.url[2]);
		srct.ui.wizard.requestPIN = -1;
		srct.ui.redirectTo(req, res, req.url, "/wizard");
		return true;
	}

	sr.perform(srct.ui.session.user, action);

	return false;
}



CreateTrustCenterRequestController.prototype.getCreateView = function(req, res, srct) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var form =	<div>
				<h1>Create CA Subject</h1>
				<p>This service will create a new Certification Authority subject.</p>
			</div>

	if (srct.ui.session.user.roles.indexOf(RoleDAO.ID_Subscriber) >= 0) {
		form.appendChild(
			<form class="pure-form" action="" method="post" enctype="multipart/form-data">
					<button class="pure-button" type="submit" name="action" value="create">Start Request</button>
			</form>
		);
	} else {
		form.appendChild(
			<p>You need a subscription to create a new Root Certification Authority.</p>
		)
	}

	return form;
}



CreateTrustCenterRequestController.prototype.getProcessView = function(req, res, srct, sr) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var div = <div />;

	div.appendChild(srct.renderForm(req, res, sr));

// 	if (sr.hasCertificates() > 0) {
// 		div.appendChild( <br/> );
// 		div.appendChild( <h2>Certificates</h2> );
// 		div.appendChild(srct.renderCertificateList(req, res, sr));
// 	}

	return div;
}
