/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2016 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for CertificateServiceRequest
 */

ServiceRequestModel = require('pki-as-a-service/service/ServiceRequestModel').ServiceRequestModel;
SubjectDAO = require('scsh/pki-db/db/SubjectDAO').SubjectDAO;
CommonUI = require('scsh/srv-cc1/CommonUI').CommonUI;
I18N = require('scsh/srv-cc1/I18N').I18N;




I18N.addResources([
	{ lang: "EN", keys: {
		"msg.ar.title": "Assign Role",
		"msg.ar.ardata": "Select Roles",
		"msg.ar.assigned": "Assigned Roles",
		"msg.ar.subject": "Subject",
		"msg.ar.roles": "Roles",
		"msg.ar.noAssignableRoles": "No assignable role",
		"msg.ar.allRevoked": "All roles have been revoked",


		"action.save": "Save",
		"action.assign": "Assign",
		"action.revoke": "Revoke"
	}}
//	,
//	{ lang: "DE", keys: {
//		"action.save": "Speichern"
//	}}
]);



function AssignRoleServiceRequestController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new AssignRoleServiceRequestController()");
}

exports.AssignRoleServiceRequestController = AssignRoleServiceRequestController;



AssignRoleServiceRequestController.prototype.getSubject = function(req, res, srct) {
	var parameter = CommonUI.parseQueryString(req.queryString);
	var id = Number(parameter.subject);

	GPSystem.log(GPSystem.DEBUG, module.id, "typeof argument id " + typeof(id));
	GPSystem.log(GPSystem.DEBUG, module.id, "id = " + id);

	if (isNaN(id) || id == 0) {
		throw new GPError(module.id, GPError.INVALID_DATA, 0, "Argument id not valid in URL");
	}

	var dao = srct.service.daof.getSubjectDAO();
	var bo = dao.getSubject(id);
	if (!bo) {
		throw new GPError(module.id, GPError.INVALID_DATA, 0, "No subject found with id " + id);
	}

	var factory = srct.service.pluginRegistry.getFactoryForSubject(bo.type);
	if (!factory) {
		throw new GPError(module.id, GPError.INVALID_DATA, 0, "Can not find factory for subject " + bo.type);
	}

	var subject = factory.getSubject(bo);
	return subject;
}



AssignRoleServiceRequestController.prototype.createRequest = function(srct, subjectId) {

	var srDAO = srct.service.daof.getServiceRequestDAO();

	var t = {
		process: "AssignRoleServiceRequest",
		title: srct.i18n("msg.ar.title"),
		originatorId: srct.ui.session.user.id,
		recipientId: subjectId,
		state: "Created",
		content: "{}"
	};

	var bo = srDAO.newServiceRequest(t);
	return bo;
}



AssignRoleServiceRequestController.prototype.postCreateAction = function(req, res, srct, action) {
	var subject = this.getSubject(req, res, srct);
	if (!subject.canRead(srct.ui.session.user)) {
	  return false;
	}

	var bo = this.createRequest(srct, subject.getId());

	srct.ui.redirectTo(req, res, req.url, "/sr/" + bo.id);
	return true;
}



AssignRoleServiceRequestController.prototype.restfulPostProcessAction = function(req, res, srct, sr, action) {
	GPSystem.log(GPSystem.DEBUG, module.id, "restfulPostProcessAction: " + action);
	var s = req.getEntityAsString();
	if (s) {
		try	{
			var reqo = JSON.parse(s);
		}
		catch(e) {
			GPSystem.log(GPSystem.ERROR, module.id, "Error parsing JSON request: " + e);
			res.setStatus(HttpResponse.SC_BAD_REQUEST);
			return;
		}
	} else {
		var reqo = [];
	}
	GPSystem.log(GPSystem.DEBUG, module.id, "getEntityAsString: " +s);

	switch(action) {
	case "action.submit":
	case "action.save":
		if (!sr.setFields(srct.ui.session.user, reqo)) {
			GPSystem.log(GPSystem.DEBUG, module.id, "Error setting fields for reqo: " + reqo);
			// TODO return json with invalid fields
			return true;
		}
		break;
	}

	sr.perform(srct.ui.session.user, action);

	return false;
}



AssignRoleServiceRequestController.prototype.postProcessAction = function(req, res, srct, sr, action) {
	print("handleAction: " + action);

	switch(action) {
	case "action.save":
	case "action.assign":
	case "action.revoke":
		if (!sr.setFields(srct.ui.session.user, req.parameters)) {
			var page = srct.getProcessView(req, res, sr);
			srct.ui.sendPage(req, res, req.url, page);
			return true;
		}
		break;
	}

	sr.perform(srct.ui.session.user, action);

	return false;
}



AssignRoleServiceRequestController.prototype.getCreateView = function(req, res, srct) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var parameter = CommonUI.parseQueryString(req.queryString);
	var id = parameter.subject;
	var subjectLink = srct.ui.homeURL(req.url) + "/subject/" + id;

	var form =	<div>
				<h1>Assign User Roles</h1>
				<p>This service request assigns a set of roles to <a href={subjectLink}>{"User " + id}</a></p>

				<form class="pure-form" action="" method="post" enctype="multipart/form-data">
					<button class="pure-button" type="submit" name="action" value="create">Start Request</button>
				</form>
			</div>

	return form;
}



AssignRoleServiceRequestController.prototype.getProcessView = function(req, res, srct, sr) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var div = <div />;

	div.appendChild(srct.renderForm(req, res, sr));

	return div;
}