/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2024 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Service request controller for ResetRetryCounterServiceRequest
 */

var I18N = require('scsh/srv-cc1/I18N').I18N;



I18N.addResources([
	{ lang: "EN", keys: {
		"msg.rrc.title": "Reset Retry Counter",
		"msg.rrc.pin": "User PIN",
	}},
	{ lang: "DE", keys: {
		"msg.rrc.title": "PIN-Zurücksetzung",
		"msg.rrc.pin": "Benutzer-PIN",
	}}
]);



function ResetRetryCounterServiceRequestController() {
	GPSystem.log(GPSystem.DEBUG, module.id, "new ResetRetryCounterServiceRequestController()");
}

exports.ResetRetryCounterServiceRequestController = ResetRetryCounterServiceRequestController;



ResetRetryCounterServiceRequestController.prototype.createRequest = function(service, parameter) {

	var srDAO = service.daof.getServiceRequestDAO();

	var t = {
		process: "ResetRetryCounterServiceRequest",
		title: I18N.t(parameter.lang, "msg.rrc.title"),
		originatorId: parameter.originatorId,
		state: "New request",
		assignedToRole: parameter.issueTSR.getRecipient().getRARoleId(),
		content: {
			tokenId: parameter.tokenId,
			issueTSRId: parameter.issueTSR.getId()
		}
	};

	if (parameter.issueTSR.isResetRetryCounterWithNewPINAllowed()) {
		var crypto = new Crypto();
		t.content.pin = service.generateActivationCode(6);
	}

	var bo = srDAO.newServiceRequest(t);
	return bo;
}



ResetRetryCounterServiceRequestController.prototype.postCreateAction = function(req, res, srct, action) {
// 	var bo = this.createRequest(srct, req.parameters);
//
// 	srct.ui.redirectTo(req, res, req.url, "/sr/" + bo.id);
// 	return true;
	GPSystem.log(GPSystem.WARN, module.id, "postCreateAction not implemented");
	return false;
}



ResetRetryCounterServiceRequestController.prototype.postProcessAction = function(req, res, srct, sr, action) {
	GPSystem.log(GPSystem.DEBUG, module.id, "postProcessAction: " + action);

	switch(action) {
	case "action.save":
	case "action.submit":
	case "action.approve":
	case "action.reject":
		if (!sr.setFields(srct.ui.session.user, req.parameters)) {
			var page = srct.getProcessView(req, res, sr);
			srct.ui.sendPage(req, res, req.url, page);
			return true;
		}
		break;
	}

	sr.perform(srct.ui.session.user, action);

	return false;
}



/**
 * No Create View necessary.
 */
ResetRetryCounterServiceRequestController.prototype.getCreateView = function(req, res, srct) {
	default xml namespace = "http://www.w3.org/1999/xhtml";
	GPSystem.log(GPSystem.WARN, module.id, "getCreateView not implemented");
	var form =	<div></div>
	return form;
}



ResetRetryCounterServiceRequestController.prototype.getProcessView = function(req, res, srct, sr) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	var div = <div />;

	div.appendChild(srct.renderForm(req, res, sr));

	return div;
}
