/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2010 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Configuration
 */

// Copy this file to etc/configuration.js to overwrite defaults defined in startup.js

GPSystem.log(GPSystem.INFO, "pki-as-a-service.config", "Sourcing from etc/configuration.js");

Config.global = {
	// Set the serverURL to the URL at which the service is visible for users. This is typically
	// server (e.g. Apache Proxy) that is exposed on the Internet
	serverURL: "http://localhost:8080",

	// allowResetDB allows recreating all database tables from the GUI using the ?op=resetdb URL
	// This is for testing only and must never be enabled on a production system
	allowResetDB: false,

	// Disable the ability for users to self-register a token.
	disableSelfRegistration: false,

	// For new user the role subscriber shall be automatically granted.
	// This is for the sandbox system only and must never be enabled on a production system
	grantSubscriberRole: false,

	// Reinitialize the first registered HSM in the HSM service during the resetdb process
	// This is for testing only and must never be enabled on a production system
	reinitializeHSMOnResetDB: false,

	// allowChangeConfig allows changing configuration settings using the ?op=changeconfig URL
	// This is for testing only and must never be enabled on a production system
	allowChangeConfig: false,

	// allowDevHSM globally allows the use of SmartCard-HSM issues under the Development Scheme Root CA (UTSRCACC1).
	allowDevHSM: false
}

Config.database = {
	type: "H2",
	url: "jdbc:h2:~/paas",
	user: "sa",
	password: ""
}
/*
 *	// For MySQL you need to make sure that mysql-connector-java.jar is in the classpath
 *	Config.database = {
 *		type: "MySQL",
 *		url: "jdbc:mysql://localhost/paas",
 *		user: "root",
 *		password: "super"
 *	}
 */

Config.services = [
{
	type: "PAAS",
	name: "PKIaaS",
	description: "The PKI-as-a-Service Portal",
	url: "paas",
	port: 8080,
	smtpConfig: {
		smtpserver: "smtp.mi.cardcontact.de",
		emailfrom: "do-not-reply@cardcontact.de",
		emailAdmin: "andreas.schwier@cardcontact.de"
	},

	dfnPKI: {
		rtURL: "http://localhost:8081/rt",
		apiURL: "https://localhost:8443",

		keyStore: new KeyStore("BC", "PKCS12", "../dfn-pki-connector/etc/tls/clientkeystore.p12", "password"),
		keyPassword: "password",
		trustStore: new KeyStore("BC", "PKCS12", "../dfn-pki-connector/etc/tls/truststore.p12", "password"),
	}
}
];

Config.keystore = {
	withHSMService: {
		// Add locally connected SmartCard-HSMs.
		// readerName		is the PC/SC name of the reader for accessing the SmartCard-HSM
		// protectedPINEntry	set to true to enable PIN entry on the server, e.g using the OCF PIN dialog or class 3 PIN reader.
		//			This is useful if the server is running on a workstation
		// pin			Set a predefined PIN for the service
//		localHSMs: [
//			{ readerName: "REINER SCT cyberJack RFID komfort (5968333780) 00 00", protectedPINEntry: true },
//			{ readerName: "Identive SCT3522CC token [CCID Interface] (55521515601800) 00 00", protectedPINEntry: false, pin: "648219" }
//		]
	}
};
