/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2016 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Card related actions performed in the UI
 */



CommonUI			= require('scsh/srv-cc1/CommonUI').CommonUI;
CardAction			= require('scsh/srv-cc1/CardAction').CardAction;



function PKIAPICardActionWizard(ui, apiURL, srID, keyStore, trustStore, keyPassword, data, rtURL, redirectUrl) {
	CardAction.call(this, ui);
	this.apiURL = apiURL;
	this.srID = srID;
	this.keyStore = keyStore;
	this.trustStore = trustStore;
	this.keyPassword = keyPassword;
	this.data = data;
	this.rtURL = rtURL;
	this.redirectUrl = redirectUrl;
	this.requestPIN = 1;
	GPSystem.log(GPSystem.DEBUG, module.id, "new PKIAPICardActionWizard(" + srID + "," + redirectUrl + ")");

}


PKIAPICardActionWizard.prototype = Object.create(CardAction.prototype);
PKIAPICardActionWizard.constructor = PKIAPICardActionWizard;

exports.PKIAPICardActionWizard = PKIAPICardActionWizard;



/**
 * Return the page depending from the current state.
 * After the handleCard operation getPage returns null
 *
 * @param {HttpRequest} req the request object
 * @param {HttpResponse} req the response object
 */
PKIAPICardActionWizard.prototype.getPage = function(req, res, url) {
	GPSystem.log(GPSystem.DEBUG, module.id, "getPage() : CardAction state: " + this.state);

	if (this.page) {
		return null;
	}
	this.page = this.getProgressPage(req, res);
	return this.page;
}



PKIAPICardActionWizard.prototype.cardAction = function(session) {
	GPSystem.log(GPSystem.DEBUG, module.id, "cardAction()");

	var c = new URLConnection(this.apiURL + "/api/sr/" + this.srID + "/action");

	if (typeof(this.keyStore) != "undefined") {
		c.setTLSKeyStores(this.trustStore, this.keyStore, this.keyPassword);
	} else if (typeof(this.trustStore) != "undefined") {
		c.setTLSKeyStores(this.trustStore);
	}

	c.addHeaderField("Content-Type", "application/json");
	c.addHeaderField("Accept", "application/json");
	var rsp = c.post(JSON.stringify(this.data));

	print(rsp);

	var cookie = c.getHeaderField("Set-Cookie");
	var combinedCookie = "";
	for (var i = 0; i < cookie.length; i++) {
		var eol = cookie[i].indexOf(";");
		if (eol < 0) {
			eol = cookie[i].length;
		}
		var elem = cookie[i].substr(0, eol);
		if (i > 0) {
			combinedCookie += "; ";
		}
		combinedCookie += elem;
	}

	var session = combinedCookie.substring("JSESSIONID=".length);
	GPSystem.log(GPSystem.DEBUG, module.id, "Set session to" + session);
	return session;
}



/**
 * Get the activation link for the redirect to the local client
 *
 * @param {HttpRequest} req the request object
 * @param {HttpResponse} req the response object
 */
PKIAPICardActionWizard.prototype.getActivationLink = function(req, res, requestPin) {
	default xml namespace = "http://www.w3.org/1999/xhtml";

	GPSystem.log(GPSystem.DEBUG, module.id, "getActivationLink");

	var rndstr = Math.floor(Math.random() * 10000000).toString();

	var sessionId = this.cardAction();

	var rturl = this.rtURL + "/rt";
	var url = "http://127.0.0.1:27001/" + rndstr + ".png?url=" + rturl + "&sessionId=" + sessionId;

	if (requestPin >= 0) {
		 url += "&pinrequired=" + requestPin;
	}
	GPSystem.log(GPSystem.DEBUG, module.id, "url = " + url);

	return <img onload="window.location.reload()" onerror="alert('Could not connect to local client. Is the client running ?');window.location.reload()" src={url} width="16" height="16"/>;
}



PKIAPICardActionWizard.prototype.handleRequest = function(req, res) {
	default xml namespace = "http://www.w3.org/1999/xhtml";
	GPSystem.log(GPSystem.DEBUG, module.id, "handleRequest");

	var page = this.getPage(req, res, req.url);
	if (page) {
		var t = this.ui.generateTemplate(req.url);
		var c = t..div.(@id == "content");
		c.div = page;
		this.ui.sendPage(req, res, req.url, t);
	} else {
		GPSystem.log(GPSystem.DEBUG, module.id, "redirect to " + this.redirectUrl);
		this.ui.redirectTo(req, res, req.url, this.redirectUrl);
	}
}
